/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.resources;

import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.DatelineModelVetoException;
import com.dlsc.flexgantt.model.dateline.IDatelineModelListener;
import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.DemoControlsPanel;
import com.dlsc.flexgantt.showcase.demo.resources.MacResourceGanttChart;
import com.dlsc.flexgantt.showcase.demo.resources.ResourceGanttChart;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.GanttChartFrame;
import com.dlsc.flexgantt.swing.layer.system.RowLayer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class ResourceDemo
extends AbstractDemo {
    public ResourceDemo() {
        super("Resources");
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return new String[]{"MacResourceGanttChart", "Resource", "ResourceCrosshairPolicy", "ResourceDemo", "ResourceGanttChart", "ResourceModel", "ResourceNode", "ResourceTreeTableCellRenderer"};
    }

    @Override
    public void run(boolean embedded) {
        final GanttChart gc2 = this.isMacOSX() ? new MacResourceGanttChart() : new ResourceGanttChart();
        gc2.getTimeline().getEventline().setVisible(false);
        gc2.resetToPreferredSizes();
        gc2.getDatelineModel().addDatelineModelListener(new IDatelineModelListener(){

            @Override
            public void datelineModelChanged(DatelineModelEvent evt) {
                if (evt.getId().equals((Object)DatelineModelEvent.ID.REQUESTED_VISIBLE_TIME_SPAN_CHANGED)) {
                    // empty if block
                }
            }

            @Override
            public void datelineModelWillChange(DatelineModelEvent evt) throws DatelineModelVetoException {
            }
        });
        final RowLayer rowLayer = gc2.getLayerContainer().getSystemLayer(RowLayer.class);
        rowLayer.setPaintingFocus(false);
        final JCheckBox focusBox = new JCheckBox("Paint the row focus", rowLayer.isPaintingFocus());
        focusBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                rowLayer.setPaintingFocus(focusBox.isSelected());
            }
        });
        final JCheckBox crosshairBox = new JCheckBox("Show crosshair", rowLayer.isPaintingFocus());
        crosshairBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                gc2.setCrosshairVisible(crosshairBox.isSelected());
            }
        });
        DemoControlsPanel controlsPanel = new DemoControlsPanel(this);
        controlsPanel.setLayout(new MigLayout("insets 0 0 0 0, wrap 1", "[]", "[]"));
        controlsPanel.add(focusBox);
        controlsPanel.add(crosshairBox);
        GanttChartFrame<?> frame = this.createFrame("Resources", gc2, embedded);
        frame.add("East", controlsPanel);
        frame.center();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new ResourceDemo());
    }
}

