/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.paging;

import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.gantt.DefaultActivityObject;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import com.dlsc.flexgantt.model.gantt.Layer;
import com.dlsc.flexgantt.model.paging.Page;
import com.dlsc.flexgantt.util.LabelType;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;

public class PagingDemoGanttChartModel
extends DefaultGanttChartModel<DefaultGanttChartNode<String, ITimelineObject>, ITimelineObject> {
    private List<Page> loadedPages = new LinkedList<Page>();
    private Layer layer = new Layer("Layer");
    private final int ROW_COUNT = 10;
    private DefaultGanttChartNode[] node;

    public PagingDemoGanttChartModel() {
        super(new DefaultGanttChartNode());
        this.layer.removeFeature(ILayer.Feature.TIMELINE_OBJECT_DESCRIPTIONS);
        this.addLayer(this.layer);
        DefaultGanttChartNode rootNode = (DefaultGanttChartNode)this.getRoot();
        this.node = new DefaultGanttChartNode[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            this.node[i2] = new DefaultGanttChartNode(true);
            this.node[i2].setRowLineVisible(false, true);
            this.node[i2].setKey("Node " + i2);
            rootNode.add(this.node[i2]);
            for (int j2 = 0; j2 < 3; ++j2) {
                DefaultGanttChartNode subNode = new DefaultGanttChartNode(false);
                subNode.setKey("Sub Node " + j2);
                if (j2 < 2) {
                    subNode.setRowLineVisible(false, false);
                }
                subNode.setColumnValue(Calendar.getInstance().getTime(), 0);
                subNode.setValueEditable(0, true);
                this.node[i2].add(subNode);
            }
        }
    }

    public void loadPage(Page page, IProgressMonitor monitor) {
        if (!this.loadedPages.contains(page)) {
            this.doLoadPage(page, monitor);
            this.loadedPages.add(page);
        }
    }

    private void doLoadPage(Page page, IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("Loading timeline objects...", 10);
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            for (int j2 = 0; j2 < 3; ++j2) {
                int k2 = 0;
                while ((double)k2 < Math.random() * 500.0) {
                    DefaultActivityObject tlo = new DefaultActivityObject();
                    int offset = (int)(Math.random() * 334.0);
                    Calendar c2 = Calendar.getInstance();
                    c2.setTimeInMillis(page.getTimeSpan().getStartTime());
                    c2.add(6, offset);
                    Calendar c22 = Calendar.getInstance();
                    c22.setTimeInMillis(page.getTimeSpan().getStartTime());
                    c22.add(6, offset);
                    c22.add(6, Math.max(3, (int)(Math.random() * 10.0)));
                    if (Math.random() < 0.66) {
                        tlo.setTimeSpan(new TimeSpan(c2, c22));
                    } else {
                        tlo.setTimeSpan(new TimeSpan(c2));
                    }
                    ((DefaultGanttChartNode)this.node[i2].getChildAt(j2)).addTimelineObject(this.layer, tlo);
                    String label = "Timeline Object " + k2;
                    tlo.setLabel(label, LabelType.DESCRIPTION);
                    if (monitor != null) {
                        monitor.subTask(label);
                    }
                    ++k2;
                }
            }
            if (monitor == null) continue;
            monitor.worked(1);
            try {
                Thread.sleep(250L);
                continue;
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        if (monitor != null) {
            monitor.done();
        }
    }
}

