/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.paging;

import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.paging.IPagingModelListener;
import com.dlsc.flexgantt.model.paging.PagingEvent;
import com.dlsc.flexgantt.model.paging.PagingVetoException;
import com.dlsc.flexgantt.model.treetable.KeyColumn;
import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.DemoControlsPanel;
import com.dlsc.flexgantt.showcase.demo.paging.PagingDemoGanttChartModel;
import com.dlsc.flexgantt.showcase.demo.paging.PagingDemoPagingModel;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.GanttChartFrame;
import com.dlsc.flexgantt.swing.PagingControlPanel;
import com.dlsc.flexgantt.swing.util.AbstractSwingWorker;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class PagingDemo
extends AbstractDemo
implements IPagingModelListener {
    private PagingDemoGanttChartModel model;
    private GanttChart gc;
    private JCheckBox confirmCheckBox;

    public PagingDemo() {
        super("Paging");
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return new String[]{"PagingDemo", "PagingDemoGanttChartModel", "PagingDemoPagingModel"};
    }

    @Override
    public void run(boolean embedded) {
        this.gc = this.createGanttChart();
        PagingDemoPagingModel pagingModel = new PagingDemoPagingModel();
        this.gc.setPagingModel(pagingModel);
        pagingModel.addPagingModelListener(this);
        this.model = new PagingDemoGanttChartModel();
        this.model.loadPage(pagingModel.getPage(), null);
        this.gc.setModel(this.model);
        this.gc.expandAll();
        KeyColumn key = this.gc.getColumnModel().getKeyColumn();
        key.setWidth(200);
        this.gc.resetToPreferredSizes();
        this.gc.getTreeTable().setRootVisible(false);
        GanttChartFrame<?> frame = this.createFrame("Paging", this.gc, embedded);
        DemoControlsPanel controls = new DemoControlsPanel(this);
        frame.add("East", controls);
        controls.setLayout(new MigLayout("insets 0 0 0 0, wrap 1", "[grow]", "[][]"));
        PagingControlPanel pagingControlPanel = new PagingControlPanel(this.gc);
        pagingControlPanel.setBorder(this.createTitledBorder("Paging Controls"));
        controls.add((Component)pagingControlPanel, "grow");
        this.confirmCheckBox = new JCheckBox("Confirm page changes", false);
        controls.add((Component)this.confirmCheckBox, "grow");
        frame.center();
        frame.setVisible(true);
    }

    @Override
    public void pageChanged(final PagingEvent evt) {
        AbstractSwingWorker worker = new AbstractSwingWorker(){

            @Override
            public Object construct() {
                GanttChartFrame frame = (GanttChartFrame)PagingDemo.this.getFrame();
                frame.showBusy();
                IProgressMonitor monitor = ((AbstractGanttChart)frame.getGanttChart()).getProgressMonitorFactory().createProgressMonitor();
                PagingDemo.this.model.loadPage(evt.getPage(), monitor);
                return null;
            }

            @Override
            public void finished() {
                GanttChartFrame frame = (GanttChartFrame)PagingDemo.this.getFrame();
                frame.showReady();
            }
        };
        worker.start();
    }

    @Override
    public void pageWillChange(PagingEvent evt) throws PagingVetoException {
        GanttChartFrame frame;
        int result;
        if (this.confirmCheckBox.isSelected() && (result = JOptionPane.showConfirmDialog(frame = (GanttChartFrame)this.getFrame(), "Are you sure you want to go to '" + evt.getPage().getName() + "'?", "Page Change", 0)) == 1) {
            throw new PagingVetoException(evt, "User cancelled paging");
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new PagingDemo());
    }
}

