/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.navigation;

import com.dlsc.flexgantt.model.gantt.DefaultActivityObject;
import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.DemoControlsPanel;
import com.dlsc.flexgantt.showcase.demo.navigation.NavigationDemoTimelineObjectRenderer;
import com.dlsc.flexgantt.showcase.demo.navigation.NavigationGanttChartModel;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.GanttChartFrame;
import com.dlsc.flexgantt.swing.IMessage;
import com.dlsc.flexgantt.swing.MessageTable;
import com.dlsc.flexgantt.swing.MessageTableModel;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.OverviewPalette;
import com.dlsc.flexgantt.swing.layer.timeline.DefaultTimelineObjectRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import net.miginfocom.swing.MigLayout;

public class NavigationDemo
extends AbstractDemo {
    public NavigationDemo() {
        super("Navigation");
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return new String[]{"NavigationDemo", "NavigationDemoTimelineObjectRenderer", "NavigationGanttChartModel"};
    }

    @Override
    public void run(boolean embedded) {
        NavigationGanttChartModel model = new NavigationGanttChartModel();
        GanttChart gc2 = this.createGanttChart(model);
        gc2.expandAll();
        LayerContainer lc2 = gc2.getLayerContainer();
        lc2.setTimelineObjectRenderer(Object.class, new NavigationDemoTimelineObjectRenderer());
        gc2.optimizeColumnWidth();
        gc2.resetToPreferredSizes();
        gc2.getTreeTable().setRootVisible(false);
        GanttChartFrame<?> frame = this.createFrame("Navigation", gc2, embedded);
        MessageTable table = new MessageTable(gc2, new MessageTableModel(gc2));
        table.setAutoResizeMode(0);
        List<IMessage> messages = model.getMessages();
        for (IMessage msg : messages) {
            gc2.addMessage(msg);
        }
        lc2.setTimelineObjectRenderer(Object.class, new DefaultTimelineObjectRenderer());
        lc2.setTimelineObjectRenderer(DefaultActivityObject.class, new NavigationDemoTimelineObjectRenderer());
        JScrollPane scroll = new JScrollPane(table);
        scroll.setBorder(new LineBorder(Color.BLACK));
        scroll.setPreferredSize(new Dimension(10, 200));
        JPanel scrollPanel = new JPanel();
        scrollPanel.setLayout(new BorderLayout());
        scrollPanel.add("Center", scroll);
        scrollPanel.setBorder(this.createTitledBorder("Messages"));
        OverviewPalette overview = new OverviewPalette(lc2);
        lc2.setTimelineObjectStatusIcon("warning", NavigationDemoTimelineObjectRenderer.warningIcon);
        lc2.setTimelineObjectStatusIcon("error", NavigationDemoTimelineObjectRenderer.errorIcon);
        lc2.setTimelineObjectStatusIcon("info", NavigationDemoTimelineObjectRenderer.infoIcon);
        lc2.setTimelineObjectStatusIcon("warning", NavigationDemoTimelineObjectRenderer.warningIcon);
        lc2.setTimelineObjectStatusIcon("error", NavigationDemoTimelineObjectRenderer.errorIcon);
        lc2.setTimelineObjectStatusIcon("info", NavigationDemoTimelineObjectRenderer.infoIcon);
        JPanel overviewPanel = new JPanel();
        overviewPanel.setLayout(new BorderLayout(10, 10));
        overviewPanel.add("Center", overview);
        overviewPanel.setBorder(this.createTitledBorder("Overview / Radar"));
        DemoControlsPanel content = new DemoControlsPanel(this);
        ((Container)content).setLayout(new MigLayout("insets 0 0 0 0, wrap 1", "[grow]", "[]"));
        ((Container)content).add((Component)overviewPanel, "grow");
        ((Container)content).add((Component)scrollPanel, "grow");
        frame.add("East", content);
        frame.center();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new NavigationDemo());
    }
}

