/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.lazyloading;

import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.treetable.DefaultColumnModel;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.DemoControlsPanel;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.GanttChartFrame;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.util.AbstractSwingWorker;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class LazyLoadingDemo
extends AbstractDemo
implements TreeWillExpandListener {
    private GanttChart gc;
    private JRadioButton modal;
    private JRadioButton nonModal;
    private JRadioButton infinite;

    public LazyLoadingDemo() {
        super("Lazy Loading");
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return new String[]{"LazyLoadingDemo"};
    }

    @Override
    public void run(boolean embedded) {
        DefaultGanttChartNode root = new DefaultGanttChartNode();
        root.setKey("Root");
        root.setColumnValue(Boolean.FALSE, 0);
        root.setColumnValue(10, 1);
        DefaultGanttChartModel model = new DefaultGanttChartModel(root, true);
        this.gc = this.createGanttChart(model);
        this.gc.getTreeTable().setCreationEnabled(true);
        TreeTable table = this.gc.getTreeTable();
        table.setCreationEnabled(false);
        table.addTreeWillExpandListener(this);
        table.collapseAll();
        DefaultColumnModel colModel = (DefaultColumnModel)this.gc.getColumnModel();
        colModel.getKeyColumn().setWidth(200);
        TreeTableColumn loadedColumn = new TreeTableColumn("Loaded", Boolean.class, 0);
        loadedColumn.setWidth(50);
        colModel.addColumn(loadedColumn);
        TreeTableColumn countColumn = new TreeTableColumn("Children", Integer.class, 1);
        countColumn.setWidth(50);
        colModel.addColumn(countColumn);
        this.gc.resetToPreferredSizes();
        GanttChartFrame<?> frame = this.createFrame("Lazy Loading", this.gc, embedded);
        DemoControlsPanel controls = new DemoControlsPanel(this);
        ((Container)controls).setLayout(new BorderLayout());
        JPanel group = new JPanel();
        group.setBorder(this.createTitledBorder("Progress Bar Location"));
        group.setLayout(new GridLayout(3, 1));
        this.modal = new JRadioButton("Dialog");
        this.nonModal = new JRadioButton("Status Bar");
        this.infinite = new JRadioButton("Infinite");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.modal);
        bg.add(this.nonModal);
        bg.add(this.infinite);
        this.modal.setSelected(true);
        group.add(this.modal);
        group.add(this.nonModal);
        group.add(this.infinite);
        ((Container)controls).add("North", group);
        frame.add("East", controls);
        if (embedded) {
            frame.setDefaultCloseOperation(2);
        } else {
            frame.setDefaultCloseOperation(3);
        }
        frame.center();
        frame.setVisible(true);
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(final TreeExpansionEvent event) throws ExpandVetoException {
        AbstractSwingWorker worker = new AbstractSwingWorker(){

            @Override
            public Object construct() {
                GanttChartFrame frame = (GanttChartFrame)LazyLoadingDemo.this.getFrame();
                frame.showBusy();
                IProgressMonitor monitor = LazyLoadingDemo.this.gc.getProgressMonitorFactory().createProgressMonitor();
                if (LazyLoadingDemo.this.nonModal.isSelected()) {
                    monitor = (IProgressMonitor)((Object)frame.getStatusBar());
                } else if (LazyLoadingDemo.this.infinite.isSelected()) {
                    monitor = (IProgressMonitor)((Object)frame.getGlassPane());
                }
                TreePath path = event.getPath();
                DefaultGanttChartNode node = (DefaultGanttChartNode)path.getLastPathComponent();
                Object value = node.getColumnValue(0);
                if (value == null || value.equals(Boolean.FALSE)) {
                    int count = (Integer)node.getColumnValue(1);
                    monitor.beginTask("Accessing a simulated database...", count);
                    for (int i2 = 0; i2 < count; ++i2) {
                        if (!monitor.isCanceled()) {
                            monitor.worked(1);
                            DefaultGanttChartNode child = new DefaultGanttChartNode();
                            child.setKey("Node " + (i2 + 1));
                            monitor.subTask("Loading node " + (String)child.getKey());
                            try {
                                Thread.sleep(333L);
                            }
                            catch (InterruptedException e2) {
                                e2.printStackTrace();
                            }
                            child.setColumnValue(Boolean.FALSE, 0);
                            child.setColumnValue((int)(Math.random() * 25.0), 1);
                            node.add(child);
                        }
                        node.setColumnValue(node.getChildCount(), 1);
                    }
                    node.setColumnValue(Boolean.TRUE, 0);
                }
                monitor.done();
                return null;
            }

            @Override
            public void finished() {
                TreePath path = event.getPath();
                TreeTable table = (TreeTable)event.getSource();
                GanttChartFrame frame = (GanttChartFrame)LazyLoadingDemo.this.getFrame();
                frame.showReady();
                table.expandPathAnimated(path);
            }
        };
        DefaultGanttChartNode node = (DefaultGanttChartNode)event.getPath().getLastPathComponent();
        if (!((Boolean)node.getColumnValue(0)).booleanValue()) {
            worker.start();
            throw new ExpandVetoException(event);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new LazyLoadingDemo());
    }
}

