/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.demo.layers;

import com.dlsc.flexgantt.model.gantt.DefaultTimelineObject;
import com.dlsc.flexgantt.model.gantt.GanttChartModelEvent;
import com.dlsc.flexgantt.model.gantt.IGanttChartModelListener;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.DemoControlsPanel;
import com.dlsc.flexgantt.showcase.demo.layers.LayerDemoGanttChartModel;
import com.dlsc.flexgantt.showcase.demo.layers.LayerDemoLayer;
import com.dlsc.flexgantt.showcase.demo.layers.LayerDemoObjectRenderer;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.GanttChartFrame;
import com.dlsc.flexgantt.swing.layer.ILayerContainerListener;
import com.dlsc.flexgantt.swing.layer.LayerContainerEvent;
import com.dlsc.flexgantt.swing.layer.LayerPalette;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class LayerDemo
extends AbstractDemo
implements IGanttChartModelListener,
ILayerContainerListener {
    protected ILayer[] layers;
    private DemoControlsPanel controlsPanel;

    public LayerDemo() {
        super("Layers");
    }

    @Override
    public String[] getSourceCodeFileNames() {
        return new String[]{"LayerDemo", "LayerDemoGanttChartModel", "LayerDemoLayer", "LayerDemoObjectRenderer"};
    }

    @Override
    public void run(boolean embedded) {
        LayerDemoGanttChartModel model = new LayerDemoGanttChartModel();
        final GanttChart gc2 = this.createGanttChart(model);
        Iterator<ILayer> iter = model.getLayers();
        while (iter.hasNext()) {
            LayerDemoLayer layer = (LayerDemoLayer)iter.next();
            gc2.getLayerContainer().setLayerIcon(layer, layer);
        }
        gc2.getTreeTable().setRootVisible(false);
        gc2.getLayerContainer().setTimelineObjectRenderer(DefaultTimelineObject.class, new LayerDemoObjectRenderer());
        for (TimelineObjectLayer layer : gc2.getLayerContainer().getTimelineObjectLayers()) {
            layer.setAlpha((float)Math.max(0.3, Math.random()));
        }
        GanttChartFrame<?> frame = this.createFrame("Layers", gc2, embedded);
        LayerPalette palette = new LayerPalette(gc2.getLayerContainer());
        palette.addContainerListener(new ContainerListener(){

            @Override
            public void componentRemoved(ContainerEvent evt) {
            }

            @Override
            public void componentAdded(ContainerEvent evt) {
                LayerDemo.this.controlsPanel.initAgain();
            }
        });
        JPanel paletteWrapper = new JPanel();
        paletteWrapper.setLayout(new BorderLayout());
        paletteWrapper.add("Center", palette);
        paletteWrapper.setBorder(this.createTitledBorder("Top Gantt Layers"));
        JPanel controls = new JPanel();
        controls.setLayout(new MigLayout("insets 0 0 0 0, wrap 1", "[]", "[][]"));
        controls.add(paletteWrapper);
        String propName = "com.dlsc.flexgantt.debug.layernames";
        SecurityManager sm = System.getSecurityManager();
        try {
            if (sm != null) {
                sm.checkPropertyAccess("com.dlsc.flexgantt.debug.layernames");
            }
            final JCheckBox showLayerNames = new JCheckBox("Show Layer Names", Boolean.getBoolean("com.dlsc.flexgantt.debug.layernames"));
            showLayerNames.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    System.setProperty("com.dlsc.flexgantt.debug.layernames", Boolean.toString(showLayerNames.isSelected()));
                    gc2.repaint();
                    if (showLayerNames.isSelected()) {
                        gc2.getLayerContainer().scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                    }
                }
            });
            controls.add(showLayerNames);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.controlsPanel = new DemoControlsPanel(this);
        this.controlsPanel.setLayout(new BorderLayout());
        this.controlsPanel.add("North", controls);
        frame.add("East", this.controlsPanel);
        frame.center();
        frame.setVisible(true);
        model.addGanttChartModelListener(this);
        gc2.getLayerContainer().addLayerContainerListener(this);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new LayerDemo());
    }

    @Override
    public void ganttChartChanged(GanttChartModelEvent evt) {
        this.controlsPanel.initAgain();
    }

    @Override
    public void layerContainerChanged(LayerContainerEvent evt) {
        this.controlsPanel.initAgain();
    }
}

