/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase.customers;

import com.dlsc.flexgantt.showcase.AbstractPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class CustomersPanel
extends AbstractPage {
    private JPanel[] logoPanel = new JPanel[2];

    public CustomersPanel() {
        this.setLayout(new BorderLayout(10, 10));
        JPanel namesPanel = new JPanel();
        namesPanel.setBorder(new EmptyBorder(20, 20, 20, 0));
        namesPanel.setOpaque(false);
        this.add("Center", namesPanel);
        this.logoPanel[0] = new JPanel();
        this.logoPanel[1] = new JPanel();
        this.logoPanel[0].setOpaque(false);
        this.logoPanel[1].setOpaque(false);
        this.logoPanel[0].setPreferredSize(new Dimension(120, 100));
        this.logoPanel[1].setPreferredSize(new Dimension(120, 100));
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new GridLayout(1, 2, 10, 10));
        wrapper.add(this.logoPanel[0]);
        wrapper.add(this.logoPanel[1]);
        wrapper.setOpaque(false);
        wrapper.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.add("East", wrapper);
        List<Customer> customers = this.getCustomers();
        int s2 = customers.size();
        int cols = 3;
        namesPanel.setLayout(new GridLayout(0, cols, 5, 5));
        for (int i2 = 0; i2 < s2; ++i2) {
            Customer customer = customers.get(i2);
            JLabel label = new JLabel();
            label.setFont(label.getFont().deriveFont(10.0f));
            label.setText(customer.name);
            label.setOpaque(false);
            label.setForeground(Color.WHITE);
            namesPanel.add(label);
        }
    }

    private List<Customer> getCustomers() {
        LinkedList<Customer> customers = new LinkedList<Customer>();
        InputStream stream = this.getClass().getResourceAsStream("customers.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            String line = reader.readLine();
            boolean first = true;
            while (line != null) {
                StringTokenizer st = new StringTokenizer(line, ",");
                String customerName = st.nextToken().trim();
                URL icon = null;
                if (st.hasMoreTokens()) {
                    String iconName = st.nextToken().trim();
                    icon = this.getClass().getResource(iconName);
                    if (icon != null) {
                        ImageIcon imageIcon = new ImageIcon(icon);
                        Image image = imageIcon.getImage();
                        int width = image.getWidth(this);
                        int height = image.getHeight(this);
                        double sf = (double)this.logoPanel[0].getPreferredSize().width / (double)Math.max(width, height);
                        image = image.getScaledInstance((int)((double)width * sf), (int)((double)height * sf), 4);
                        imageIcon.setImage(image);
                        if (first) {
                            this.logoPanel[0].add(new JLabel(imageIcon));
                        } else {
                            this.logoPanel[1].add(new JLabel(imageIcon));
                        }
                        first = !first;
                    }
                }
                Customer cust = new Customer(customerName, icon);
                customers.add(cust);
                line = reader.readLine();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        Collections.sort(customers);
        return customers;
    }

    class Customer
    implements Comparable<Customer> {
        String name;
        URL icon;

        public Customer(String name, URL icon) {
            this.name = name;
            this.icon = icon;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Customer o2) {
            return this.name.compareTo(o2.name);
        }
    }
}

