/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.icons.png16vista.Png16VistaIconMap;
import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.NavigationHeader;
import com.dlsc.flexgantt.showcase.TransitionPanel;
import com.dlsc.flexgantt.showcase.demo.actions.ActionsDemo;
import com.dlsc.flexgantt.showcase.demo.calendar.CalendarDemo;
import com.dlsc.flexgantt.showcase.demo.commands.CommandsDemo;
import com.dlsc.flexgantt.showcase.demo.editing.EditingDemo;
import com.dlsc.flexgantt.showcase.demo.layers.LayerDemo;
import com.dlsc.flexgantt.showcase.demo.lazyloading.LazyLoadingDemo;
import com.dlsc.flexgantt.showcase.demo.multiline.MultiLineDemo;
import com.dlsc.flexgantt.showcase.demo.navigation.NavigationDemo;
import com.dlsc.flexgantt.showcase.demo.paging.PagingDemo;
import com.dlsc.flexgantt.showcase.demo.relationships.RelationshipDemo;
import com.dlsc.flexgantt.showcase.demo.resources.ResourceDemo;
import com.dlsc.flexgantt.showcase.demo.spreadsheet.SpreadsheetDemo;
import com.dlsc.flexgantt.showcase.demo.textures.TextureDemo;
import com.dlsc.flexgantt.showcase.demo.timeline.TimelineDemo;
import com.dlsc.flexgantt.showcase.demo.timenow.TimeNowDemo;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.util.Version;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Toolkit;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.GlossPainter;
import org.jdesktop.swingx.painter.MattePainter;

public class DemoLauncher
extends JFrame {
    private TransitionPanel tp;

    public DemoLauncher() {
        super("Demo Launcher (FlexGantt Version " + Version.getVersion() + ", Java Version: " + System.getProperty("java.version") + ")");
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setIconImage(((ImageIcon)IconRegistry.getIcon(IconId.FLEXGANTT_16)).getImage());
        NavigationHeader navigation = new NavigationHeader(this);
        this.tp = new TransitionPanel(this, navigation);
        this.add("North", this.createHeaderPanel());
        this.add("Center", this.tp);
        this.setSize(920, 850);
        this.center();
    }

    protected JPanel createHeaderPanel() {
        URL url = this.getClass().getResource("Logo.png");
        ImageIcon icon = new ImageIcon(url);
        icon.setImage(icon.getImage().getScaledInstance((int)((double)icon.getIconWidth() * 0.6), (int)((double)icon.getIconHeight() * 0.6), 4));
        JLabel logoLabel = new JLabel(icon);
        logoLabel.setVerticalAlignment(0);
        logoLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
        ImageIcon nameIcon = new ImageIcon(this.getClass().getResource("Name-m.png"));
        nameIcon.setImage(nameIcon.getImage().getScaledInstance((int)((double)nameIcon.getIconWidth() * 0.9), (int)((double)nameIcon.getIconHeight() * 0.9), 4));
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BorderLayout());
        namePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        namePanel.setOpaque(false);
        JLabel iconLabel = new JLabel(nameIcon);
        iconLabel.setHorizontalAlignment(2);
        namePanel.add("Center", iconLabel);
        JLabel textLabel = new JLabel("DLSC Software & Consulting GmbH, Zurich, Switzerland");
        textLabel.setForeground(Color.WHITE);
        textLabel.setBorder(new EmptyBorder(0, 4, 0, 0));
        namePanel.add("South", textLabel);
        JXPanel panel = new JXPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackgroundPainter(new CompoundPainter(new MattePainter(new GradientPaint(0.0f, 0.0f, new Color(123, 132, 145), 0.0f, 100.0f, new Color(69, 70, 80))), new GlossPainter()));
        panel.add("East", logoLabel);
        panel.add("West", namePanel);
        panel.setPreferredSize(new Dimension(100, 100));
        return panel;
    }

    public void showDemos() {
        this.tp.startTransition(TransitionPanel.ScreenType.DEMOS);
    }

    public void showCustomers() {
        this.tp.startTransition(TransitionPanel.ScreenType.CUSTOMERS);
    }

    private void center() {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int xOffset = (size.width - this.getSize().width) / 2;
        int yOffset = (size.height - this.getSize().height) / 2;
        this.setLocation(xOffset, yOffset);
    }

    public void showSnapshots() {
        this.tp.startTransition(TransitionPanel.ScreenType.SNAPSHOTS);
    }

    public List<AbstractDemo> getDemos() {
        LinkedList<AbstractDemo> demos = new LinkedList<AbstractDemo>();
        demos.add(new LayerDemo());
        demos.add(new ResourceDemo());
        demos.add(new CalendarDemo());
        demos.add(new TextureDemo());
        demos.add(new CommandsDemo());
        demos.add(new NavigationDemo());
        demos.add(new TimeNowDemo());
        demos.add(new MultiLineDemo());
        demos.add(new TimelineDemo());
        demos.add(new LazyLoadingDemo());
        demos.add(new PagingDemo());
        demos.add(new EditingDemo());
        demos.add(new SpreadsheetDemo());
        demos.add(new RelationshipDemo());
        demos.add(new ActionsDemo());
        return demos;
    }

    public static void main(String[] args) {
        IconRegistry.setIconMap(new Png16VistaIconMap());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Selector.setGlobalAnimationEnabled(false);
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                DemoLauncher frame = new DemoLauncher();
                frame.setVisible(true);
            }
        });
    }
}

