/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase;

import com.dlsc.flexgantt.showcase.AbstractDemo;
import com.dlsc.flexgantt.showcase.util.scanner.SourceCodeViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.MattePainter;

public class DemoControlsPanel
extends JXPanel {
    private JPanel shadowPanel;
    private JPanel contentPanel;
    private JXLabel instructionsLabel;
    private AbstractDemo demo;

    public DemoControlsPanel(final AbstractDemo demo) {
        this.demo = demo;
        this.setOpaque(false);
        super.setLayout(new MigLayout("insets 0 0 0 10, wrap 2", "[][grow]", "[][grow][]"));
        this.shadowPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g2) {
                g2.setColor(new Color(0, 0, 0, 100));
                g2.drawLine(0, 0, 0, this.getHeight());
                g2.setColor(new Color(0, 0, 0, 80));
                g2.drawLine(1, 0, 1, this.getHeight());
                g2.setColor(new Color(0, 0, 0, 40));
                g2.drawLine(2, 0, 2, this.getHeight());
                g2.setColor(new Color(0, 0, 0, 10));
                g2.drawLine(3, 0, 3, this.getHeight());
            }
        };
        this.shadowPanel.setOpaque(false);
        this.shadowPanel.setMinimumSize(new Dimension(5, 1));
        this.contentPanel = new JPanel();
        this.contentPanel.setOpaque(false);
        this.instructionsLabel = new JXLabel(demo.getInstructions());
        this.instructionsLabel.setLineWrap(true);
        this.instructionsLabel.setMaxLineSpan(200);
        this.instructionsLabel.setPreferredSize(new Dimension(200, 1));
        this.instructionsLabel.setVerticalAlignment(1);
        JPanel codePanel = new JPanel();
        codePanel.setLayout(new GridLayout(0, 1, 5, 5));
        codePanel.setOpaque(false);
        codePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        ImageIcon javaIcon = new ImageIcon(DemoControlsPanel.class.getResource("java-file.gif"));
        for (final String fileName : demo.getSourceCodeFileNames()) {
            JLabel fileLabel = new JLabel(fileName + ".java", javaIcon, 2);
            fileLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    if (e2.getButton() == 1 && e2.getClickCount() == 1) {
                        InputStream in = demo.getClass().getResourceAsStream(fileName);
                        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                        StringBuilder sb2 = new StringBuilder();
                        try {
                            String line = reader.readLine();
                            while (line != null) {
                                sb2.append(line);
                                sb2.append(System.getProperty("line.separator"));
                                line = reader.readLine();
                            }
                            SourceCodeViewer edit = new SourceCodeViewer();
                            edit.setTitle(fileName + ".java");
                            edit.display(sb2.toString());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
            fileLabel.setCursor(Cursor.getPredefinedCursor(12));
            codePanel.add(fileLabel);
        }
        super.add((Component)this.shadowPanel, "spany 3, grow");
        super.add((Component)this.instructionsLabel, "gapy 10, grow");
        super.add((Component)this.contentPanel, "grow");
        super.add((Component)codePanel, "grow");
        try {
            BufferedImage image = ImageIO.read(DemoControlsPanel.class.getResource("macwallpaper.png"));
            this.setBackgroundPainter(new CompoundPainter(new MattePainter(new TexturePaint(image, new Rectangle(0, 0, image.getWidth(), image.getHeight())))));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.init(this);
    }

    @Override
    public void setLayout(LayoutManager manager) {
        if (this.contentPanel != null) {
            this.contentPanel.setLayout(manager);
        } else {
            super.setLayout(manager);
        }
    }

    @Override
    public Component add(Component comp) {
        this.init(comp);
        return this.contentPanel.add(comp);
    }

    @Override
    public Component add(Component comp, int index) {
        this.init(comp);
        return this.contentPanel.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.init(comp);
        this.contentPanel.add(comp, constraints);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.init(comp);
        this.contentPanel.add(comp, constraints, index);
    }

    @Override
    public Component add(String name, Component comp) {
        this.init(comp);
        return this.contentPanel.add(name, comp);
    }

    private void init(Component comp) {
        if (comp instanceof JLabel) {
            comp.setForeground(Color.WHITE);
            if (this.demo.isMacOSX()) {
                comp.setFont(comp.getFont().deriveFont(1));
            }
        } else if (comp instanceof JCheckBox) {
            comp.setForeground(Color.WHITE);
            if (this.demo.isMacOSX()) {
                comp.setFont(comp.getFont().deriveFont(1));
            }
        } else if (comp instanceof JRadioButton) {
            comp.setForeground(Color.WHITE);
            if (this.demo.isMacOSX()) {
                comp.setFont(comp.getFont().deriveFont(1));
            }
        } else if (comp instanceof JSlider) {
            comp.setForeground(Color.WHITE);
        }
        if (comp instanceof JComponent) {
            JComponent jc2 = (JComponent)comp;
            if (jc2 instanceof JPanel) {
                jc2.setOpaque(false);
            }
            Border border = jc2.getBorder();
            if (this.demo.isMacOSX() && border instanceof TitledBorder) {
                TitledBorder tb2 = (TitledBorder)border;
                tb2.setTitleColor(Color.WHITE);
                if (this.demo.isMacOSX()) {
                    Font font = tb2.getTitleFont();
                    if (font == null) {
                        font = comp.getFont();
                    }
                    if (font != null) {
                        tb2.setTitleFont(font.deriveFont(1));
                    }
                }
            }
        }
        if (comp instanceof Container && this.isNotTitledPanelOnWindows(comp)) {
            Container con = (Container)comp;
            for (Component child : con.getComponents()) {
                this.init(child);
            }
        }
    }

    private boolean isNotTitledPanelOnWindows(Component comp) {
        if (this.demo.isMacOSX()) {
            return true;
        }
        if (comp instanceof JPanel) {
            JPanel panel = (JPanel)comp;
            return !(panel.getBorder() instanceof TitledBorder);
        }
        return true;
    }

    @Override
    public void setBorder(Border border) {
        if (this.contentPanel != null) {
            this.contentPanel.setBorder(border);
            if (border instanceof TitledBorder) {
                TitledBorder tb2 = (TitledBorder)border;
                tb2.setTitleColor(Color.WHITE);
                tb2.setTitleFont(tb2.getTitleFont().deriveFont(1));
            }
        } else {
            super.setBorder(border);
        }
    }

    public void initAgain() {
        this.init(this.contentPanel);
    }
}

