/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.showcase;

import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.icons.png16vista.Png16VistaIconMap;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.treetable.DefaultMutableTreeTableNode;
import com.dlsc.flexgantt.showcase.OSXAdapter;
import com.dlsc.flexgantt.showcase.util.DualTestMenuBar;
import com.dlsc.flexgantt.showcase.util.TestMenuBar;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.DualGanttChart;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.GanttChartFrame;
import com.dlsc.flexgantt.swing.StatusBar;
import com.dlsc.flexgantt.swing.mac.MacDualGanttChart;
import com.dlsc.flexgantt.swing.mac.MacGanttChart;
import com.dlsc.flexgantt.swing.mac.MacGanttChartFrame;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.util.FlexGanttLicenseManager;
import de.centigrade.bizlaf.BizLafControl;
import de.centigrade.bizlaf.BizLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public abstract class AbstractDemo
implements Comparable<AbstractDemo>,
Runnable {
    private boolean initLaf = true;
    private String name;
    private JFrame frame;

    protected AbstractDemo(String name) {
        this.name = name;
        if (FlexGanttLicenseManager.getLicensee().equals("---")) {
            FlexGanttLicenseManager.setLicenseKey("LIC=FlexGanttDLSCDemo;VEN=DLSC;VER=2;RUN=no;CTR=1;SignCode=1F;Signature=302D021500907C37A109CEDF8E643412E8805CA063E9C620DC021478E1443301589260D1E04EB3BF990C5B2DC56A05");
        }
        if (this.initLaf) {
            if (!this.isMacOSX()) {
                this.initLaf = false;
                try {
                    UIManager.setLookAndFeel(new BizLookAndFeel());
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            } else {
                DefaultMutableTreeTableNode.setDefaultRowHeight(24);
                IconRegistry.setIconMap(new Png16VistaIconMap());
                this.configureUIDefaults();
            }
        }
    }

    public void configureUIDefaults() {
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration enumeration = defaults.keys();
        Font standardFont = defaults.getFont("Label.font").deriveFont(11.0f);
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            Object obj = defaults.get(key);
            if (!(obj instanceof Font)) continue;
            UIManager.put(key, standardFont);
        }
        UIManager.put("Label.font", standardFont);
        UIManager.put("Button.font", standardFont);
        UIManager.getLookAndFeelDefaults().put("defaultFont", standardFont);
    }

    public boolean isMacOSX() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    public String[] getSourceCodeFileNames() {
        return new String[0];
    }

    public String getName() {
        return this.name;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    private void setFrame(JFrame frame) {
        this.frame = frame;
    }

    public abstract void run(boolean var1);

    public URL getDemoIcon() {
        return this.getClass().getResource("snapshot.png");
    }

    public URL getDemoInIcon() {
        return this.getClass().getResource("snapshot-in.png");
    }

    public URL getSnapshot() {
        return this.getClass().getResource("snapshot.gif");
    }

    public String getSummary() {
        return this.getText("summary.txt");
    }

    public String getInstructions() {
        return this.getText("instructions.txt");
    }

    public String getDescription() {
        return this.getText("description.txt");
    }

    private String getText(String fileName) {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(fileName));
        BufferedReader buffer = new BufferedReader(reader);
        StringBuffer sb2 = new StringBuffer();
        try {
            String line = buffer.readLine();
            while (line != null) {
                sb2.append(line);
                sb2.append(" ");
                line = buffer.readLine();
            }
            return sb2.toString();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return "<Unable to read demo information text file>";
        }
    }

    @Override
    public int compareTo(AbstractDemo demo) {
        return this.name.compareTo(demo.getName());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void run() {
        this.run(false);
    }

    private void init(AbstractGanttChart gc2) {
        if (this.isMacOSX()) {
            for (TreeTable table : gc2.getTreeTables()) {
                table.setDefaultRowHeight(40);
            }
        }
    }

    protected GanttChart createGanttChart() {
        MacGanttChart gc2 = null;
        gc2 = new MacGanttChart();
        this.init(gc2);
        return gc2;
    }

    protected GanttChart createGanttChart(IGanttChartModel<?, ?> model) {
        GanttChart gc2 = this.createGanttChart();
        gc2.setModel(model);
        return gc2;
    }

    protected DualGanttChart createDualGanttChart(IGanttChartModel model1, IGanttChartModel model2) {
        DualGanttChart gc2 = this.createDualGanttChart();
        gc2.setModel(model1);
        gc2.setSecondaryModel(model2);
        return gc2;
    }

    protected DualGanttChart createDualGanttChart() {
        MacDualGanttChart gc2 = null;
        gc2 = new MacDualGanttChart();
        this.init(gc2);
        return gc2;
    }

    protected GanttChartFrame<?> createFrame(String title, AbstractGanttChart gc2, boolean embedded) {
        GanttChartFrame frame = null;
        if (this.isMacOSX()) {
            frame = new MacGanttChartFrame<AbstractGanttChart>(title, gc2);
        } else {
            frame = new GanttChartFrame<AbstractGanttChart>(title, gc2);
            if (gc2 instanceof DualGanttChart) {
                frame.setJMenuBar(new DualTestMenuBar((DualGanttChart)gc2));
            } else {
                frame.setJMenuBar(new TestMenuBar((GanttChart)gc2));
            }
        }
        if (embedded) {
            frame.setDefaultCloseOperation(2);
        } else {
            frame.setDefaultCloseOperation(3);
        }
        this.tuneStatusBar(frame.getStatusBar());
        StatusBar statusBar = (StatusBar)frame.getStatusBar();
        statusBar.getResizeIconLabel().setVisible(false);
        frame.getToolBar().setFloatable(false);
        BizLafControl.get().setStyle(frame.getToolBar(), ":bizlaf:RibbonLike");
        BizLafControl.get().setStyle(frame.getStatusBar(), ":bizlaf:FooterBar");
        if (this.isMacOSX()) {
            OSXAdapter.setWindowCanFullScreen(frame, true);
        }
        this.init((AbstractGanttChart)frame.getGanttChart());
        frame.setSize(1200, 900);
        frame.center();
        this.setFrame(frame);
        return frame;
    }

    private void tuneStatusBar(JComponent comp) {
        if (comp instanceof JLabel) {
            comp.setForeground(Color.WHITE);
            BizLafControl.get().setStyle(comp, ":bizlaf:Shadowed");
        }
        for (Component c2 : comp.getComponents()) {
            this.tuneStatusBar((JComponent)c2);
        }
    }

    protected Border createTitledBorder(String title) {
        Border b2 = UIManager.getBorder("TitledBorder.aquaVariant");
        if (b2 == null) {
            TitledBorder border = new TitledBorder(title);
            return border;
        }
        TitledBorder border = new TitledBorder(b2, title);
        return border;
    }
}

