/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.treetable;

import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.treetable.IMutableTreeTableNode;
import com.dlsc.flexgantt.model.treetable.ITreeTableNode;
import com.dlsc.flexgantt.model.treetable.TreeTableColumn;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class DefaultMutableTreeTableNode<T>
extends DefaultMutableTreeNode
implements IMutableTreeTableNode,
Comparator {
    private static int defaultRowHeight = 20;
    private Object key;
    private Object[] values = new Object[0];
    private boolean selectable = true;
    private int dragActions = 3;
    private boolean resizable = true;
    private boolean rowLineVisibleExpanded = true;
    private boolean rowLineVisibleCollapsed = true;
    private boolean deletable = true;
    private boolean[] editable = new boolean[0];
    private int rowHeight;
    private int rowHeightMinimum;
    private int rowHeightMaximum;
    private boolean keyEditable;
    private String ttt;
    private Object rowHeaderValue;
    private Comparator[] comparators;
    private int[] sortModelIndices;
    private boolean[] sortDirections;
    private Comparator keyComparator;
    private Object popupObject;
    private Object extendedPopupObject;
    private Object popupTitleObject;

    public DefaultMutableTreeTableNode(T userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
        this.rowHeight = Math.max(defaultRowHeight, IconRegistry.getIconDimension().height + 2);
        this.rowHeightMinimum = 5;
        this.rowHeightMaximum = -1;
    }

    public DefaultMutableTreeTableNode(T userObject) {
        super(userObject);
        this.rowHeight = Math.max(defaultRowHeight, IconRegistry.getIconDimension().height + 2);
        this.rowHeightMinimum = 5;
        this.rowHeightMaximum = -1;
    }

    public DefaultMutableTreeTableNode(boolean allowsChildren) {
        super(null, allowsChildren);
        this.rowHeight = Math.max(defaultRowHeight, IconRegistry.getIconDimension().height + 2);
        this.rowHeightMinimum = 5;
        this.rowHeightMaximum = -1;
    }

    public DefaultMutableTreeTableNode() {
        this.rowHeight = Math.max(defaultRowHeight, IconRegistry.getIconDimension().height + 2);
        this.rowHeightMinimum = 5;
        this.rowHeightMaximum = -1;
    }

    @Override
    public int getRowHeight() {
        return this.rowHeight;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    @Override
    public int getRowHeightMaximum() {
        return this.rowHeightMaximum;
    }

    public void setRowHeightMaximum(int max) {
        this.rowHeightMaximum = max;
    }

    @Override
    public int getRowHeightMinimum() {
        return this.rowHeightMinimum;
    }

    public void setRowHeightMinimum(int min) {
        this.rowHeightMinimum = min;
    }

    @Override
    public Object getColumnValue(int modelIndex) {
        if (modelIndex == -1) {
            return this.getKey();
        }
        if (modelIndex < this.values.length) {
            return this.values[modelIndex];
        }
        return null;
    }

    @Override
    public void setColumnValue(Object value, int modelIndex) {
        if (modelIndex >= this.values.length) {
            Object[] newValues = new Object[modelIndex + 1];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            this.values = newValues;
        }
        this.values[modelIndex] = value;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean b2) {
        this.selectable = b2;
    }

    @Override
    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    @Override
    public boolean isRowLineVisible(boolean expanded) {
        if (expanded) {
            return this.rowLineVisibleExpanded;
        }
        return this.rowLineVisibleCollapsed;
    }

    public void setRowLineVisible(boolean visibleExpanded, boolean visibleCollapsed) {
        this.rowLineVisibleCollapsed = visibleCollapsed;
        this.rowLineVisibleExpanded = visibleExpanded;
    }

    @Override
    public boolean isValueEditable(int modelIndex) {
        if (modelIndex < this.editable.length) {
            return this.editable[modelIndex];
        }
        return false;
    }

    public void setValueEditable(int modelIndex, boolean b2) {
        if (modelIndex >= this.editable.length) {
            boolean[] newEditable = new boolean[modelIndex + 1];
            System.arraycopy(this.editable, 0, newEditable, 0, this.editable.length);
            this.editable = newEditable;
        }
        this.editable[modelIndex] = b2;
    }

    @Override
    public boolean isKeyEditable() {
        return this.keyEditable;
    }

    public void setKeyEditable(boolean b2) {
        this.keyEditable = b2;
    }

    public void setToolTipText(String ttt) {
        this.ttt = ttt;
    }

    @Override
    public String getToolTipText(TreeTableColumn modelIndex) {
        return this.ttt;
    }

    @Override
    public void setKey(Object key) {
        this.key = key;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean b2) {
        this.deletable = b2;
    }

    @Override
    public Object getRowHeaderValue() {
        if (this.rowHeaderValue != null) {
            return this.rowHeaderValue;
        }
        return this;
    }

    @Override
    public void setRowHeaderValue(Object value) {
        this.rowHeaderValue = value;
    }

    @Override
    @Deprecated
    public final void setUserObject(Object userObject) {
        super.setUserObject(userObject);
    }

    @Override
    @Deprecated
    public final Object getUserObject() {
        return super.getUserObject();
    }

    public void setTypedUserObject(T userObject) {
        super.setUserObject(userObject);
    }

    public T getTypedUserObject() {
        return (T)this.getUserObject();
    }

    @Override
    public void sort(int[] modelIndices, boolean[] sortDirections) {
        this.sortModelIndices = modelIndices;
        this.sortDirections = sortDirections;
        if (this.children != null) {
            Collections.sort(this.children, this);
            for (Object obj : this.children) {
                ITreeTableNode child = (ITreeTableNode)obj;
                child.sort(modelIndices, sortDirections);
            }
        }
    }

    public boolean isSorting() {
        return this.sortModelIndices != null && this.sortModelIndices.length > 0;
    }

    @Override
    public void add(MutableTreeNode newChild) {
        super.add(newChild);
        if (this.isSorting()) {
            this.sort(this.sortModelIndices, this.sortDirections);
        }
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        if (this.isSorting()) {
            this.sort(this.sortModelIndices, this.sortDirections);
        }
    }

    public void setKeyComparator(Comparator comparator) {
        this.keyComparator = comparator;
    }

    public Comparator getKeyComparator() {
        return this.keyComparator;
    }

    public void setComparator(int modelIndex, Comparator comp) {
        if (modelIndex < 0) {
            throw new IllegalArgumentException("invalid model index, modelIndex = " + modelIndex);
        }
        if (this.comparators == null) {
            this.comparators = new Comparator[modelIndex + 1];
        } else if (this.comparators.length - 1 < modelIndex) {
            Comparator[] newComps = new Comparator[modelIndex + 1];
            System.arraycopy(this.comparators, 0, newComps, 0, this.comparators.length);
            this.comparators = newComps;
        }
        this.comparators[modelIndex] = comp;
    }

    public Comparator getComparator(int modelIndex) {
        if (this.comparators != null && modelIndex < this.comparators.length) {
            return this.comparators[modelIndex];
        }
        return null;
    }

    public int compare(Object o1, Object o2) {
        ITreeTableNode node1 = (ITreeTableNode)o1;
        ITreeTableNode node2 = (ITreeTableNode)o2;
        for (int i2 = 0; i2 < this.sortModelIndices.length; ++i2) {
            int modelIndex = this.sortModelIndices[i2];
            boolean ascending = this.sortDirections[i2];
            Object value1 = null;
            Object value2 = null;
            if (modelIndex == -1) {
                value1 = node1.getKey();
                value2 = node2.getKey();
            } else {
                value1 = node1.getColumnValue(modelIndex);
                value2 = node2.getColumnValue(modelIndex);
            }
            int result = this.compare(modelIndex, value1, value2, ascending);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    protected int compare(int modelIndex, Object value1, Object value2, boolean ascending) {
        if (value1 == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        Comparator comparator = null;
        comparator = modelIndex == -1 ? this.getKeyComparator() : this.getComparator(modelIndex);
        int result = 0;
        if (comparator != null) {
            result = comparator.compare(value1, value2);
        } else if (value1 instanceof Comparable) {
            result = ((Comparable)value1).compareTo(value2);
        } else {
            throw new IllegalArgumentException("unable to sort model index " + modelIndex + " - no comparator has been specified and the column value does not implement the Comparable interface, value type was = " + value1.getClass().getName());
        }
        if (!ascending && result != 0) {
            result = -result;
        }
        return result;
    }

    @Override
    public int getDragActions() {
        if (this.getParent() == null) {
            return 1;
        }
        return this.dragActions;
    }

    public void setDragActions(int actions) {
        this.dragActions = actions;
    }

    @Override
    public int getDropActions(ITreeTableNode dropCandidate) {
        if (!this.isNodeAncestor(dropCandidate)) {
            return 3;
        }
        return 0;
    }

    @Override
    public boolean isReassignable(Object parent) {
        if (parent != null && parent instanceof MutableTreeNode) {
            MutableTreeNode node = (MutableTreeNode)parent;
            return node.getAllowsChildren();
        }
        return false;
    }

    @Override
    public Object getPopupObject(boolean extended) {
        if (extended) {
            return this.extendedPopupObject;
        }
        return this.popupObject;
    }

    public void setPopupObject(Object object, boolean extended) {
        if (extended) {
            this.extendedPopupObject = object;
        } else {
            this.popupObject = object;
        }
    }

    @Override
    public Object getPopupTitleObject() {
        return this.popupTitleObject;
    }

    public void setPopupTitleObject(Object object) {
        this.popupTitleObject = object;
    }

    public static void setDefaultRowHeight(int height) {
        if (height < 1) {
            throw new IllegalArgumentException("default row height must be larger than 0");
        }
        defaultRowHeight = height;
    }
}

