/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.gantt;

import com.dlsc.flexgantt.model.dateline.IGranularity;
import com.dlsc.flexgantt.model.gantt.ISpreadsheet;

public class Spreadsheet
implements ISpreadsheet {
    private String name;
    private IGranularity<?> granularity;
    private int cellWidth;
    private Class defaultValueType = Integer.class;

    public Spreadsheet(String name, IGranularity<?> granularity, int cellWidth, Class defaultValueType) {
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        if (granularity == null) {
            throw new IllegalArgumentException("granularity can not be null");
        }
        if (cellWidth < 1) {
            throw new IllegalArgumentException("cell width must be larger than 0");
        }
        if (defaultValueType == null) {
            throw new IllegalArgumentException("default value type can not be null");
        }
        this.name = name;
        this.granularity = granularity;
        this.cellWidth = cellWidth;
        this.defaultValueType = defaultValueType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IGranularity<?> getGranularity() {
        return this.granularity;
    }

    @Override
    public int getCellWidth() {
        return this.cellWidth;
    }

    @Override
    public Class getDefaultValueType() {
        return this.defaultValueType;
    }
}

