/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.calendar;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.calendar.AbstractCalendarEntry;
import com.dlsc.flexgantt.model.calendar.AbstractEntryCalendarModel;
import com.dlsc.flexgantt.model.calendar.HolidayCalendarEntry;
import com.dlsc.flexgantt.model.calendar.WeekendCalendarEntry;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.model.gantt.IGanttChartNode;
import com.dlsc.flexgantt.swing.timeline.TimeGranularityDatelineModel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimeGranularityCalendarModel<T extends IGanttChartNode, S extends AbstractCalendarEntry>
extends AbstractEntryCalendarModel<T, S> {
    private static final Logger LOGGER = Logger.getLogger(TimeGranularityCalendarModel.class.getName());
    private List<Integer> weekendDays = new ArrayList<Integer>();
    private Calendar calendar = Calendar.getInstance();
    private ITimeSpan lastSpan;
    private List result = new ArrayList();
    private Map<String, Date> holidays = new HashMap<String, Date>();
    private TimeZone timeZone = TimeZone.getDefault();

    public TimeGranularityCalendarModel() {
        this.weekendDays.add(7);
        this.weekendDays.add(1);
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new IllegalArgumentException("time zone can not be NULL");
        }
        this.timeZone = timeZone;
        this.lastSpan = null;
        this.calendar = Calendar.getInstance(timeZone);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Iterator<S> getCalendarEntries(IDatelineModel model, ITimeSpan span) {
        return this.calculateEntries(model, span).iterator();
    }

    @Override
    public Iterator<S> getCalendarEntries(IDatelineModel model, T node, ITimeSpan span) {
        return Collections.EMPTY_LIST.iterator();
    }

    protected List<S> calculateEntries(IDatelineModel model, ITimeSpan span) {
        Object granularity;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("model = " + model);
            LOGGER.fine("time span = " + span);
        }
        if ((granularity = model.getGranularity()) instanceof TimeGranularity) {
            TimeGranularity tg = (TimeGranularity)granularity;
            if (this.isGranularityShowingCalendarEntries(tg)) {
                if (!span.equals(this.lastSpan)) {
                    this.lastSpan = span;
                    this.result.clear();
                    this.calendar.setTimeZone(model.getTimeZone());
                    this.calendar.setTimeInMillis(span.getStartTime());
                    TimeGranularity.DAY_SHORT.adjustCalendar(this.calendar);
                    do {
                        long et;
                        long st = this.calendar.getTimeInMillis();
                        if (this.isHoliday(this.calendar, true)) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.finer("is an annual holiday = " + this.calendar.getTime());
                            }
                            TimeGranularity.DAY_SHORT.increment(this.calendar);
                            et = this.calendar.getTimeInMillis();
                            this.result.add(new HolidayCalendarEntry(new TimeSpan(st, et), true));
                            continue;
                        }
                        if (this.isHoliday(this.calendar, false)) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.finer("is a holiday = " + this.calendar.getTime());
                            }
                            TimeGranularity.DAY_SHORT.increment(this.calendar);
                            et = this.calendar.getTimeInMillis();
                            this.result.add(new HolidayCalendarEntry(new TimeSpan(st, et), false));
                            continue;
                        }
                        if (this.isWeekendDay(this.calendar.get(7))) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.finer("is a weekend day = " + this.calendar.getTime());
                            }
                            TimeGranularity.DAY_SHORT.increment(this.calendar);
                            et = this.calendar.getTimeInMillis();
                            this.result.add(new WeekendCalendarEntry(new TimeSpan(st, et)));
                            continue;
                        }
                        TimeGranularity.DAY_SHORT.increment(this.calendar);
                    } while (span.getEndTime() > this.calendar.getTimeInMillis());
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("same time span, not recalculating");
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("number of calendar entries = " + this.result.size());
                }
                return new ArrayList(this.result);
            }
            LOGGER.fine("time granularity is not within the supported range of [" + TimeGranularity.HOUR + "," + TimeGranularity.DAY_TINY + "]");
            this.result.clear();
            return new ArrayList(this.result);
        }
        LOGGER.fine("dateline model is not of type " + TimeGranularityDatelineModel.class.getName());
        this.result.clear();
        return new ArrayList(this.result);
    }

    protected boolean isGranularityShowingCalendarEntries(TimeGranularity tg) {
        return tg.isInside(TimeGranularity.DAY_SHORT, TimeGranularity.DAY_TINY);
    }

    public boolean isWeekendDay(int day) {
        return this.weekendDays.contains(day);
    }

    public void setWeekendDays(int[] days) {
        this.weekendDays.clear();
        if (days != null) {
            for (int d2 : days) {
                this.weekendDays.add(d2);
            }
        }
        this.fireCalendarModelChanged();
    }

    public int[] getWeekendDays() {
        int s2 = this.weekendDays.size();
        int[] result = new int[s2];
        for (int i2 = 0; i2 < s2; ++i2) {
            result[i2] = this.weekendDays.get(i2);
        }
        return result;
    }

    public void addHoliday(long time, boolean annual) {
        this.addHoliday(new Date(time), annual);
    }

    public void addHoliday(Date date, boolean annual) {
        if (date == null) {
            throw new IllegalArgumentException("date can not be NULL");
        }
        this.holidays.put(this.getKey(date, annual), date);
        this.fireCalendarModelChanged();
    }

    public void addHoliday(Calendar calendar, boolean annual) {
        if (calendar == null) {
            throw new IllegalArgumentException("calendar can not be NULL");
        }
        this.holidays.put(this.getKey(calendar.getTime(), annual), calendar.getTime());
        this.fireCalendarModelChanged();
    }

    public void addHoliday(int year, int month, int day) {
        Calendar c2 = Calendar.getInstance(this.timeZone);
        c2.set(year, month, day);
        this.addHoliday(c2, false);
    }

    public void addHoliday(int month, int day) {
        Calendar c2 = Calendar.getInstance(this.timeZone);
        c2.set(2, month);
        c2.set(5, day);
        this.addHoliday(c2, true);
    }

    public void removeHoliday(long time, boolean annual) {
        this.removeHoliday(new Date(time), annual);
    }

    public void removeHoliday(Date date, boolean annual) {
        if (date == null) {
            throw new IllegalArgumentException("date can not be NULL");
        }
        this.holidays.remove(this.getKey(date, annual));
        this.fireCalendarModelChanged();
    }

    public void removeHoliday(Calendar calendar, boolean annual) {
        if (calendar == null) {
            throw new IllegalArgumentException("calendar can not be NULL");
        }
        this.holidays.remove(this.getKey(calendar.getTime(), annual));
        this.fireCalendarModelChanged();
    }

    private String getKey(Date date, boolean annual) {
        this.calendar.setTime(date);
        if (annual) {
            return this.calendar.get(2) + "/" + this.calendar.get(5);
        }
        return this.calendar.get(1) + "/" + this.calendar.get(2) + "/" + this.calendar.get(5);
    }

    public Date[] getHolidays(boolean annual) {
        ArrayList<Date> result = new ArrayList<Date>();
        for (Date date : this.holidays.values()) {
            String key = this.getKey(date, annual);
            if (!this.holidays.containsKey(key)) continue;
            result.add(date);
        }
        int s2 = result.size();
        Date[] dates = new Date[s2];
        result.toArray(dates);
        return dates;
    }

    public boolean isHoliday(Calendar calendar, boolean annual) {
        if (calendar == null) {
            throw new IllegalArgumentException("calendar can not be NULL");
        }
        return this.isHoliday(calendar.getTime(), annual);
    }

    public boolean isHoliday(Date date, boolean annual) {
        if (date == null) {
            throw new IllegalArgumentException("date can not be NULL");
        }
        String key = this.getKey(date, annual);
        return this.holidays.containsKey(key);
    }

    public boolean isHoliday(Date date) {
        return this.isHoliday(date, true) || this.isHoliday(date, false);
    }

    @Override
    protected void fireCalendarModelChanged() {
        this.lastSpan = null;
        super.fireCalendarModelChanged();
    }
}

