/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.treetable;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.command.SubProgressMonitor;
import com.dlsc.flexgantt.model.treetable.ITreeTableNode;
import com.dlsc.flexgantt.util.Messages;

public class DefaultRowResizeCommand
extends AbstractCommand {
    private ITreeTableNode node;
    private int newRowHeight;
    private int oldRowHeight;

    public DefaultRowResizeCommand(ITreeTableNode node, int height) {
        super(Messages.getString("DefaultRowResizeCommand.NAME"));
        if (node == null) {
            throw new IllegalArgumentException("node can not be NULL");
        }
        if (height < 0) {
            throw new IllegalArgumentException("node height must be larger or equal to 0 but was " + height);
        }
        this.node = node;
        this.newRowHeight = height;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
        sub.beginTask(this.node.toString(), 1);
        this.oldRowHeight = this.node.getRowHeight();
        this.node.setRowHeight(this.newRowHeight);
        sub.worked(1);
        sub.done();
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
        sub.beginTask(Messages.getString("DefaultRowResizeCommand.RESTORING_HEIGHT_ON") + this.node, 1);
        this.node.setRowHeight(this.oldRowHeight);
        sub.worked(1);
    }

    public ITreeTableNode getNode() {
        return this.node;
    }

    public int getNewRowHeight() {
        return this.newRowHeight;
    }

    public int getOldRowHeight() {
        return this.oldRowHeight;
    }
}

