/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.treetable;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.treetable.DefaultMutableTreeTableNode;
import com.dlsc.flexgantt.model.treetable.DefaultTreeTableModel;
import com.dlsc.flexgantt.model.treetable.ITreeTableNode;
import com.dlsc.flexgantt.util.Messages;

public class DefaultChangeValueCommand
extends AbstractCommand {
    private ITreeTableNode node;
    private DefaultTreeTableModel model;
    private Object newValue;
    private Object oldValue;
    private int valueIndex;

    public DefaultChangeValueCommand(DefaultMutableTreeTableNode node, DefaultTreeTableModel model, Object value, int index) {
        super(Messages.getString("DefaultChangeValueCommand.NAME"));
        if (node == null) {
            throw new IllegalArgumentException("node can not be NULL");
        }
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        this.node = node;
        this.model = model;
        this.newValue = value;
        this.valueIndex = index;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        this.oldValue = this.model.getColumnValue(this.node, this.valueIndex);
        this.model.setColumnValue(this.node, this.newValue, this.valueIndex);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        this.model.setColumnValue(this.node, this.oldValue, this.valueIndex);
    }

    public DefaultTreeTableModel getModel() {
        return this.model;
    }

    public ITreeTableNode getNode() {
        return this.node;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public int getValueIndex() {
        return this.valueIndex;
    }
}

