/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.layer;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IActivityObject;
import com.dlsc.flexgantt.util.Messages;

public class DefaultChangePercentageCommand
extends AbstractCommand {
    private double oldPercentage;
    private double newPercentage;
    private IActivityObject activityObject;
    private DefaultGanttChartModel model;

    public DefaultChangePercentageCommand(IActivityObject object, DefaultGanttChartModel model, double percentage) {
        super(Messages.getString("DefaultChangePercentageCommand.NAME"));
        if (object == null) {
            throw new IllegalArgumentException("activityObject timeline object can not be NULL");
        }
        if (model == null) {
            throw new IllegalArgumentException("gantt chart model can not be NULL");
        }
        if (percentage < 0.0 || percentage > 100.0) {
            throw new IllegalArgumentException("percentage must be between 0 and 100, but was " + percentage);
        }
        this.activityObject = object;
        this.model = model;
        this.newPercentage = percentage;
        this.oldPercentage = object.getPercentageComplete();
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        this.activityObject.setPercentageComplete(this.newPercentage);
        this.model.timelineObjectChanged(this.activityObject);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        this.activityObject.setPercentageComplete(this.oldPercentage);
        this.model.timelineObjectChanged(this.activityObject);
    }

    public IActivityObject getActivityObject() {
        return this.activityObject;
    }

    public DefaultGanttChartModel getModel() {
        return this.model;
    }

    public double getNewPercentage() {
        return this.newPercentage;
    }

    public double getOldPercentage() {
        return this.oldPercentage;
    }
}

