/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.eventline;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.eventline.DefaultEventlineModel;
import com.dlsc.flexgantt.model.eventline.DefaultEventlineObject;
import com.dlsc.flexgantt.util.LabelType;
import com.dlsc.flexgantt.util.Messages;

public class DefaultCreateEventlineObjectCommand
extends AbstractCommand {
    private DefaultEventlineObject eventlineObject;
    private DefaultEventlineModel model;
    private ITimeSpan span;
    private String eventlineObjectName;

    public DefaultCreateEventlineObjectCommand(DefaultEventlineModel model, ITimeSpan span) {
        super(Messages.getString("DefaultCreateEventlineObjectCommand.NAME"));
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        if (span == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        this.model = model;
        this.span = span;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        if (this.eventlineObject == null) {
            this.eventlineObject = this.createEventlineObject();
            this.eventlineObject.setTimeSpan(this.span);
            this.eventlineObject.setLabel(this.eventlineObjectName, LabelType.NAME);
            this.eventlineObject.setPopupObject(this.eventlineObjectName, false);
        }
        this.model.addEventlineObject(this.eventlineObject);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        this.model.removeEventlineObject(this.eventlineObject);
    }

    protected DefaultEventlineObject createEventlineObject() {
        return new DefaultEventlineObject();
    }

    public DefaultEventlineObject getEventlineObject() {
        return this.eventlineObject;
    }

    public DefaultEventlineModel getModel() {
        return this.model;
    }

    public ITimeSpan getTimeSpan() {
        return this.span;
    }

    public void setTimeSpan(ITimeSpan span) {
        this.span = span;
    }

    public void setEventlineObjectName(String name) {
        this.eventlineObjectName = name;
    }
}

