/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command;

import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.ICommandStack;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommandStackEvent
extends EventObject {
    private static final Logger LOGGER = Logger.getLogger(CommandStackEvent.class.getName());
    private ICommand command;
    private ID id;
    private Exception commandException;

    public CommandStackEvent(ICommandStack stack, ICommand command, ID id2, Exception ex) {
        super(stack);
        this.command = command;
        this.id = id2;
        this.commandException = ex;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("new event: stack = " + stack);
            LOGGER.fine("new event: id = " + (Object)((Object)id2));
            LOGGER.fine("new event: exception = " + ex);
        }
    }

    public CommandStackEvent(ICommandStack stack, ICommand command, ID id2) {
        this(stack, command, id2, null);
    }

    public ICommand getCommand() {
        return this.command;
    }

    public ICommandStack getCommandStack() {
        return (ICommandStack)this.getSource();
    }

    public ID getId() {
        return this.id;
    }

    public Exception getCommandException() {
        return this.commandException;
    }

    @Override
    public String toString() {
        return "id = " + (Object)((Object)this.id) + " cmd = " + this.command;
    }

    public static enum ID {
        COMMAND_CANCELED,
        COMMAND_EXECUTED,
        COMMAND_FAILED,
        COMMAND_STARTED,
        COMMAND_UNDONE;

    }
}

