/*
 * Decompiled with CFR 0.152.
 */
package de.centigrade.bizlaf.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;

public abstract class CezanneLookAndFeelControl {
    protected static final String TAG_PROPERTYNAME = "Cezanne.Tag";
    protected static final String UI_DEFAULTS_KEY_REMOTE_CEZANNE_METHOD_INVOCATION = "Cezanne.RemoteMethodInvocation";
    protected static final String UI_DEFAULTS_KEY_PRODUCT_RUNTIME_SIGNATURE = "Cezanne.productRuntimeSignature";
    protected static final String CLIENTPROPERTYNAME_TRANSITIONS_ENABLED = "Cezanne.TransitionsEnabled";
    protected static final String CLIENTPROPERTYNAME_RENDER_COMPONENT_MARK = "Cezanne.RenderComponentMark";
    protected static final String REMOTE_METHOD_NAME_REFRESH_CONTEXT = "refreshContext";
    protected static final String REMOTE_METHOD_NAME_UPDATE_STYLE = "updateStyle";
    protected static final ColorUIResource DUMMY_COLOR_UI_RESOURCE = new ColorUIResource(0);

    public void setStyle(JComponent component, String style) {
        if (component == null) {
            return;
        }
        component.putClientProperty(TAG_PROPERTYNAME, style);
        if (component.getClientProperty(CLIENTPROPERTYNAME_RENDER_COMPONENT_MARK) != null) {
            this.invokeRemoteCezanneMethod(REMOTE_METHOD_NAME_UPDATE_STYLE, component);
        }
    }

    public String getStyle(JComponent component) {
        if (component == null) {
            return null;
        }
        Object style = component.getClientProperty(TAG_PROPERTYNAME);
        if (!(style instanceof String)) {
            return null;
        }
        return (String)style;
    }

    public void removeStyle(JComponent component) {
        if (component == null) {
            return;
        }
        component.putClientProperty(TAG_PROPERTYNAME, null);
    }

    public void removeStyle(JComponent component, String style) {
        if (component == null || style == null) {
            return;
        }
        String appliedStyle = this.getStyle(component);
        if (style.equals(appliedStyle)) {
            this.removeStyle(component);
        }
    }

    protected Object invokeRemoteCezanneMethod(String name) {
        return this.invokeRemoteCezanneMethod(name, new Object[0]);
    }

    protected Object invokeRemoteCezanneMethod(String name, Object ... arguments) {
        Object[] command = new Object[]{name, arguments, null};
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        uiDefaults.put(UI_DEFAULTS_KEY_REMOTE_CEZANNE_METHOD_INVOCATION, command);
        Object result = command[2];
        return result;
    }

    public abstract String getLookAndFeelClassName();

    public boolean isLookAndFeelActive() {
        return this.isLookAndFeelActive(this.getLookAndFeelClassName());
    }

    protected boolean isLookAndFeelActive(String lookAndFeelName) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel == null) {
            return false;
        }
        return lookAndFeel.getClass().getName().equals(lookAndFeelName);
    }

    public void switchLookAndFeel(String lookAndFeelName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(lookAndFeelName);
        this.updateUiAfterLookAndFeelSwitch();
    }

    public void switchLookAndFeel(LookAndFeel lookAndFeel) throws UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(lookAndFeel);
        this.updateUiAfterLookAndFeelSwitch();
    }

    protected void updateUiAfterLookAndFeelSwitch() {
        for (Window window : Window.getWindows()) {
            this.updateComponentTreeRoot(window);
        }
    }

    protected void updateComponentTreeRoot(Component component) {
        this.updateComponentTree(component);
        component.invalidate();
        component.validate();
        component.repaint();
    }

    protected void updateComponentTree(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            this.updateComponent(jComponent);
            JPopupMenu jPopupMenu = jComponent.getComponentPopupMenu();
            if (jPopupMenu != null && jPopupMenu.isVisible() && jPopupMenu.getInvoker() == jComponent) {
                this.updateComponentTreeRoot(jPopupMenu);
            }
        }
        Component[] children = null;
        if (component instanceof JMenu) {
            children = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            children = ((Container)component).getComponents();
        }
        if (children != null) {
            for (Component element : children) {
                this.updateComponentTree(element);
            }
        }
    }

    protected void updateComponent(JComponent jComponent) {
        if (jComponent instanceof JToolBar) {
            LayoutManager layout = jComponent.getLayout();
            if (layout != null && layout.getClass().getName().contains("SynthToolBarLayoutManager")) {
                jComponent.setLayout(null);
            }
            jComponent.updateUI();
            return;
        }
        if (jComponent instanceof JTable) {
            Color selectionForegroundColor;
            JTable table = (JTable)jComponent;
            Color selectionBackgroundColor = table.getSelectionBackground();
            if (selectionBackgroundColor != null && selectionBackgroundColor.getClass().getName().endsWith(".nimbus.DerivedColor")) {
                table.setSelectionBackground(DUMMY_COLOR_UI_RESOURCE);
            }
            if ((selectionForegroundColor = table.getSelectionForeground()) != null && selectionForegroundColor.getClass().getName().endsWith(".nimbus.DerivedColor")) {
                table.setSelectionForeground(DUMMY_COLOR_UI_RESOURCE);
            }
            boolean showHorizontalLines = table.getShowHorizontalLines();
            boolean showVerticalLines = table.getShowVerticalLines();
            Dimension intercellSpacing = table.getIntercellSpacing();
            table.updateUI();
            table.updateUI();
            table.setShowHorizontalLines(showHorizontalLines);
            table.setShowVerticalLines(showVerticalLines);
            table.setIntercellSpacing(intercellSpacing);
            return;
        }
        if (jComponent instanceof JList) {
            Color selectionForegroundColor;
            JList list = (JList)jComponent;
            Color selectionBackgroundColor = list.getSelectionBackground();
            if (selectionBackgroundColor != null && selectionBackgroundColor.getClass().getName().endsWith(".nimbus.DerivedColor")) {
                list.setSelectionBackground(DUMMY_COLOR_UI_RESOURCE);
            }
            if ((selectionForegroundColor = list.getSelectionForeground()) != null && selectionForegroundColor.getClass().getName().endsWith(".nimbus.DerivedColor")) {
                list.setSelectionForeground(DUMMY_COLOR_UI_RESOURCE);
            }
            jComponent.updateUI();
            return;
        }
        jComponent.updateUI();
    }

    public boolean isTransitionsEnabled(JComponent component) {
        if (component == null) {
            return false;
        }
        return !Boolean.FALSE.equals(component.getClientProperty(CLIENTPROPERTYNAME_TRANSITIONS_ENABLED));
    }

    public void setTransitionsEnabled(JComponent component, boolean enabled) {
        if (component == null) {
            return;
        }
        if (enabled == this.isTransitionsEnabled(component)) {
            return;
        }
        if (!enabled) {
            component.putClientProperty(CLIENTPROPERTYNAME_TRANSITIONS_ENABLED, Boolean.FALSE);
        }
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_NAME_REFRESH_CONTEXT, component);
        if (enabled) {
            component.putClientProperty(CLIENTPROPERTYNAME_TRANSITIONS_ENABLED, null);
        }
    }

    public String getProductRuntimeSignature() {
        return UIManager.getLookAndFeelDefaults().getString(UI_DEFAULTS_KEY_PRODUCT_RUNTIME_SIGNATURE);
    }
}

