/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.widgets;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ImageUtils {
    private ImageUtils() {
    }

    public static BufferedImage getHorizontalSubImage(Image image, int x2, int width) {
        return ImageUtils.getSubImage(image, x2, 0, width, image.getHeight(null));
    }

    public static BufferedImage getVerticalSubImage(Image image, int y2, int height) {
        return ImageUtils.getSubImage(image, 0, y2, image.getWidth(null), height);
    }

    public static BufferedImage getSubImage(Image image, int x2, int y2, int width, int height) {
        if (x2 >= image.getWidth(null)) {
            throw new IllegalArgumentException("The given x, " + x2 + ", must be less than the image width, " + width + ".");
        }
        if (y2 >= image.getHeight(null)) {
            throw new IllegalArgumentException("The given y, " + y2 + ", must be less than the image height, " + height + ".");
        }
        if (x2 + width > image.getWidth(null)) {
            throw new IllegalArgumentException("The given width must be less than or equal to the image width - x.");
        }
        if (y2 + height > image.getHeight(null)) {
            throw new IllegalArgumentException("The given height must be less than or equal to the image height - y.");
        }
        BufferedImage subImage = new BufferedImage(width, height, 6);
        Graphics graphics = subImage.getGraphics();
        graphics.drawImage(image, 0, 0, subImage.getWidth(), subImage.getHeight(), x2, y2, x2 + width, y2 + height, null);
        graphics.dispose();
        return subImage;
    }
}

