/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.macwidgets.plaf;

import com.jtechdev.macwidgets.plaf.HudPaintingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;

public class HudSliderUI
extends BasicSliderUI {
    private static final int SLIDER_KNOB_WIDTH = 11;
    private static final int SLIDER_KNOB_HEIGHT_NO_TICKS = 11;
    private static final int SLIDER_KNOB_HEIGHT_WITH_TICKS = 13;
    private static final int TRACK_HEIGHT = 4;
    private static final Color TRACK_BACKGROUND_COLOR = new Color(143, 147, 144, 100);
    private static final Color TRACK_BORDER_COLOR = new Color(255, 255, 255, 200);
    private static final Color TOP_SLIDER_KNOB_COLOR = new Color(0x555555);
    private static final Color BOTTOM_SLIDER_KNOB_COLOR = new Color(0x393939);
    private static final Color TOP_SLIDER_KNOB_PRESSED_COLOR = new Color(11580086);
    private static final Color BOTTOM_SLIDER_KNOB_PRESSED_COLOR = new Color(0x86888B);
    private static final HudPaintingUtils.ShapeProvider NO_TICKS_SHAPE_PROVIDER = HudSliderUI.createCircularSliderKnobShapeProvider();
    private static final HudPaintingUtils.ShapeProvider TICKS_SHAPE_PROVIDER = HudSliderUI.createPointedSliderKnobShapeProvider();

    public HudSliderUI(JSlider b2) {
        super(b2);
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        slider.setOpaque(false);
    }

    @Override
    protected Dimension getThumbSize() {
        int sliderKnobHeight = this.slider.getPaintTicks() ? 13 : 11;
        return new Dimension(11, sliderKnobHeight);
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        HudPaintingUtils.updateGraphicsToPaintDisabledControlIfNecessary((Graphics2D)g2, c2);
        super.paint(g2, c2);
    }

    @Override
    public void paintThumb(Graphics graphics) {
        Paint paint = HudSliderUI.createSliderKnobButtonPaint(this.isDragging(), this.thumbRect.height);
        HudPaintingUtils.ShapeProvider shapeProvider = this.slider.getPaintTicks() ? TICKS_SHAPE_PROVIDER : NO_TICKS_SHAPE_PROVIDER;
        HudPaintingUtils.paintHudControlBackground((Graphics2D)graphics, this.thumbRect, shapeProvider, paint);
    }

    @Override
    public void paintTrack(Graphics graphics) {
        Graphics2D graphics2d = (Graphics2D)graphics;
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double trackY = (double)this.slider.getHeight() / 2.0 - 2.0;
        RoundRectangle2D.Double track = new RoundRectangle2D.Double(0.0, trackY, this.slider.getWidth() - 1, 3.0, 4.0, 2.0);
        graphics.setColor(TRACK_BACKGROUND_COLOR);
        graphics2d.fill(track);
        graphics2d.setColor(TRACK_BORDER_COLOR);
        graphics2d.draw(track);
    }

    @Override
    protected int getTickLength() {
        return 5;
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        if (this.slider.getOrientation() == 0 && this.slider.getPaintTicks()) {
            this.thumbRect.y += 3;
        }
    }

    @Override
    protected void calculateTickRect() {
        super.calculateTickRect();
        if (this.slider.getOrientation() == 0) {
            ++this.tickRect.y;
        }
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g2, Rectangle tickBounds, int x2) {
        g2.setColor(Color.WHITE);
        super.paintMajorTickForHorizSlider(g2, tickBounds, x2);
    }

    @Override
    public void setThumbLocation(int x2, int y2) {
        super.setThumbLocation(x2, y2);
        this.slider.repaint();
    }

    @Override
    public void paintFocus(Graphics g2) {
    }

    private static Paint createSliderKnobButtonPaint(boolean isPressed, int height) {
        Color topColor = isPressed ? TOP_SLIDER_KNOB_PRESSED_COLOR : TOP_SLIDER_KNOB_COLOR;
        Color bottomColor = isPressed ? BOTTOM_SLIDER_KNOB_PRESSED_COLOR : BOTTOM_SLIDER_KNOB_COLOR;
        int bottomY = height - 2;
        return new GradientPaint(0.0f, 0.0f, topColor, 0.0f, bottomY, bottomColor);
    }

    private static HudPaintingUtils.ShapeProvider createCircularSliderKnobShapeProvider() {
        return new HudPaintingUtils.ShapeProvider(){

            @Override
            public Shape createShape(double x2, double y2, double width, double height) {
                return new Ellipse2D.Double(x2, y2, width, height);
            }
        };
    }

    private static HudPaintingUtils.ShapeProvider createPointedSliderKnobShapeProvider() {
        return new HudPaintingUtils.ShapeProvider(){

            @Override
            public Shape createShape(double x2, double y2, double width, double height) {
                float xFloat = (float)x2;
                float yFloat = (float)y2;
                float widthFloat = (float)width;
                float heightFloat = (float)height;
                GeneralPath path = new GeneralPath();
                path.moveTo(xFloat + 2.0f, yFloat);
                path.curveTo(xFloat + 0.25f, yFloat + 0.25f, xFloat - 0.25f, yFloat + 2.0f, xFloat, yFloat + 2.0f);
                path.lineTo(xFloat, yFloat + heightFloat / 1.6f);
                path.lineTo(xFloat + widthFloat / 2.0f, yFloat + heightFloat);
                path.lineTo(xFloat + widthFloat, yFloat + heightFloat / 1.6f);
                path.lineTo(xFloat + widthFloat, yFloat + 2.0f);
                path.curveTo(xFloat + widthFloat - 0.25f, yFloat + 2.0f, xFloat + widthFloat - 0.25f, yFloat + 0.25f, xFloat + widthFloat - 2.0f, yFloat);
                path.closePath();
                return path;
            }
        };
    }
}

