/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.macwidgets.plaf;

import com.jtechdev.macwidgets.MacFontUtils;
import com.jtechdev.macwidgets.WidgetBaseColors;
import com.jtechdev.macwidgets.plaf.HudPaintingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class HudRadioButtonUI
extends BasicRadioButtonUI {
    private boolean isDarkColorScheme = true;

    @Override
    protected void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        HudPaintingUtils.initHudComponent(b2, this.isDarkColorScheme);
        b2.setIconTextGap(5);
        this.icon = new DotIcon(this.isDarkColorScheme);
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        HudPaintingUtils.updateGraphicsToPaintDisabledControlIfNecessary((Graphics2D)g2, c2);
        super.paint(g2, c2);
    }

    @Override
    protected void paintText(Graphics g2, AbstractButton button, Rectangle textRect, String text) {
        MacFontUtils.enableAntialiasing((Graphics2D)g2);
        FontMetrics fontMetrics = g2.getFontMetrics(button.getFont());
        int mnemonicIndex = button.getDisplayedMnemonicIndex();
        g2.setColor(button.getForeground());
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fontMetrics.getAscent() + this.getTextShiftOffset());
    }

    private class DotIcon
    implements Icon {
        private final int RADIO_BUTTON_SIZE = 13;
        private final float DOT_DIAMETER = 4.25f;
        private boolean isDarkColorScheme = true;
        private Color fontColor = WidgetBaseColors.DARK_FONT_COLOR;

        public DotIcon(boolean isDarkColorScheme) {
            this.isDarkColorScheme = isDarkColorScheme;
            this.fontColor = isDarkColorScheme ? WidgetBaseColors.DARK_FONT_COLOR : WidgetBaseColors.LIGHT_FONT_COLOR;
        }

        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            AbstractButton button = (AbstractButton)c2;
            Graphics2D graphics = (Graphics2D)g2.create();
            graphics.translate(x2, y2);
            HudPaintingUtils.paintHudControlBackground(graphics, button, 13, 13, HudPaintingUtils.Roundedness.RADIO, this.isDarkColorScheme);
            this.drawDotIfNecessary(graphics, button.getModel());
            graphics.dispose();
        }

        private void drawDotIfNecessary(Graphics2D graphics, ButtonModel model) {
            if (model.isSelected()) {
                this.drawSelected(graphics, model);
            }
        }

        private void drawSelected(Graphics2D graphics, ButtonModel model) {
            Color color = model.isPressed() ? HudPaintingUtils.PRESSED_MARK_COLOR : this.fontColor;
            graphics.setColor(color);
            float offset = ((float)this.getIconWidth() - 4.25f) / 2.0f;
            Ellipse2D.Float dot = new Ellipse2D.Float(offset, offset, 4.25f, 4.25f);
            graphics.fill(dot);
        }

        @Override
        public int getIconWidth() {
            return 13;
        }

        @Override
        public int getIconHeight() {
            return 13;
        }
    }
}

