/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.macwidgets;

import com.jtechdev.macwidgets.SourceListItem;
import com.jtechdev.widgets.TextProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SourceListCategory
implements TextProvider {
    private List<SourceListItem> fItems = new ArrayList<SourceListItem>();
    private String fText;
    private final boolean fCollapsable;

    public SourceListCategory(String text) {
        this(text, true);
    }

    public SourceListCategory(String text, boolean collapsable) {
        this.checkText(text);
        this.fText = text;
        this.fCollapsable = collapsable;
    }

    private void checkText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null.");
        }
    }

    @Override
    public String getText() {
        return this.fText;
    }

    public void setText(String text) {
        this.checkText(text);
        this.fText = text;
    }

    public boolean isCollapsable() {
        return this.fCollapsable;
    }

    public int getItemCount() {
        return this.fItems.size();
    }

    public boolean containsItem(SourceListItem item) {
        SourceListItem childItem;
        boolean contains = false;
        Iterator<SourceListItem> i$ = this.fItems.iterator();
        while (i$.hasNext() && !(contains = (childItem = i$.next()).equals(item) || childItem.containsItem(item))) {
        }
        return contains;
    }

    public String toString() {
        return this.getText();
    }

    SourceListItem getItem(int index) {
        return this.fItems.get(index);
    }

    public List<SourceListItem> getItems() {
        return Collections.unmodifiableList(this.fItems);
    }

    void addItem(SourceListItem item) {
        this.fItems.add(item);
    }

    void addItem(int index, SourceListItem item) {
        this.fItems.add(index, item);
    }

    void removeItem(SourceListItem item) {
        this.fItems.remove(item);
    }

    SourceListItem removeItem(int index) {
        return this.fItems.remove(index);
    }
}

