/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.macwidgets;

import com.jtechdev.macwidgets.IAppWidgetFactory;
import com.jtechdev.macwidgets.MacWidgetFactory;
import com.jtechdev.macwidgets.SourceListCategory;
import com.jtechdev.macwidgets.SourceListClickListener;
import com.jtechdev.macwidgets.SourceListColorScheme;
import com.jtechdev.macwidgets.SourceListContextMenuProvider;
import com.jtechdev.macwidgets.SourceListControlBar;
import com.jtechdev.macwidgets.SourceListExpansionListener;
import com.jtechdev.macwidgets.SourceListItem;
import com.jtechdev.macwidgets.SourceListModel;
import com.jtechdev.macwidgets.SourceListModelListener;
import com.jtechdev.macwidgets.SourceListSelectionListener;
import com.jtechdev.macwidgets.SourceListToolTipProvider;
import com.jtechdev.macwidgets.plaf.SourceListTreeUI;
import com.jtechdev.widgets.TreeUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SourceList {
    private final SourceListModel fModel;
    private final SourceListModelListener fModelListener = this.createSourceListModelListener();
    private final List<SourceListSelectionListener> fSourceListSelectionListeners = new ArrayList<SourceListSelectionListener>();
    private final List<SourceListExpansionListener> fSourceListExpansionListeners = new ArrayList<SourceListExpansionListener>();
    private DefaultMutableTreeNode fRoot = new DefaultMutableTreeNode("root");
    private DefaultTreeModel fTreeModel = new DefaultTreeModel(this.fRoot);
    private JTree fTree = new CustomJTree(this.fTreeModel);
    private JScrollPane fScrollPane = MacWidgetFactory.createSourceListScrollPane(this.fTree);
    private final JPanel fComponent = new JPanel(new BorderLayout());
    private TreeSelectionListener fTreeSelectionListener = this.createTreeSelectionListener();
    private TreeExpansionListener fTreeExpansionListener = this.createTreeExpansionListener();
    private TreeWillExpandListener fTreeWillExpandListener = this.createTreeWillExpandListener();
    private MouseListener fMouseListener = this.createMouseListener();
    private SourceListControlBar fSourceListControlBar;
    private SourceListContextMenuProvider fContextMenuProvider = new EmptySourceListContextMenuProvider();
    private List<SourceListClickListener> fSourceListClickListeners = new ArrayList<SourceListClickListener>();
    private SourceListToolTipProvider fToolTipProvider = new EmptyToolTipProvider();

    public SourceList() {
        this(new SourceListModel());
    }

    public SourceList(SourceListModel model) {
        if (model == null) {
            throw new IllegalArgumentException("Groups cannot be null.");
        }
        this.fModel = model;
        this.fModel.addSourceListModelListener(this.fModelListener);
        this.initUi();
        for (int i2 = 0; i2 < model.getCategories().size(); ++i2) {
            this.doAddCategory(model.getCategories().get(i2), i2);
        }
    }

    private void initUi() {
        this.fComponent.add((Component)this.fScrollPane, "Center");
        this.fTree.addTreeSelectionListener(this.fTreeSelectionListener);
        this.fTree.addTreeExpansionListener(this.fTreeExpansionListener);
        this.fTree.addTreeWillExpandListener(this.fTreeWillExpandListener);
        this.fTree.addMouseListener(this.fMouseListener);
    }

    public void installSourceListControlBar(SourceListControlBar sourceListControlBar) {
        if (this.fSourceListControlBar != null) {
            throw new IllegalStateException("A SourceListControlBar has already been installed on this SourceList.");
        }
        if (sourceListControlBar == null) {
            throw new IllegalArgumentException("SourceListControlBar cannot be null.");
        }
        this.fSourceListControlBar = sourceListControlBar;
        this.fComponent.add((Component)this.fSourceListControlBar.getComponent(), "South");
    }

    public boolean isSourceListControlBarInstalled() {
        return this.fSourceListControlBar != null;
    }

    public void setSourceListContextMenuProvider(SourceListContextMenuProvider contextMenuProvider) {
        if (contextMenuProvider == null) {
            throw new IllegalArgumentException("SourceListContextMenuProvider cannot be null.");
        }
        this.fContextMenuProvider = contextMenuProvider;
    }

    public void dispose() {
        this.fModel.removeSourceListModelListener(this.fModelListener);
    }

    public SourceListItem getSelectedItem() {
        SourceListItem selectedItem = null;
        if (this.fTree.getSelectionPath() != null && this.fTree.getSelectionPath().getLastPathComponent() != null) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.fTree.getSelectionPath().getLastPathComponent();
            assert (selectedNode.getUserObject() instanceof SourceListItem) : "Only SourceListItems can be selected.";
            selectedItem = (SourceListItem)selectedNode.getUserObject();
        }
        return selectedItem;
    }

    public void setSelectedItem(SourceListItem item) {
        this.getModel().validateItemIsInModel(item);
        DefaultMutableTreeNode treeNode = SourceList.getNodeForObject(this.fRoot, item);
        this.fTree.setSelectionPath(new TreePath(treeNode.getPath()));
    }

    public void clearSelection() {
        this.fTree.clearSelection();
    }

    public void setFocusable(boolean focusable) {
        this.fTree.setFocusable(focusable);
    }

    public void useIAppStyleScrollBars() {
        IAppWidgetFactory.makeIAppScrollPane(this.fScrollPane);
    }

    public SourceListColorScheme getColorScheme() {
        return ((SourceListTreeUI)this.fTree.getUI()).getColorScheme();
    }

    public void setColorScheme(SourceListColorScheme colorScheme) {
        ((SourceListTreeUI)this.fTree.getUI()).setColorScheme(colorScheme);
    }

    public void setTransferHandler(TransferHandler transferHandler) {
        this.fTree.setDragEnabled(transferHandler != null);
        this.fTree.setTransferHandler(transferHandler);
    }

    public void scrollItemToVisible(SourceListItem item) {
        this.getModel().validateItemIsInModel(item);
        DefaultMutableTreeNode treeNode = SourceList.getNodeForObject(this.fRoot, item);
        this.fTree.scrollPathToVisible(new TreePath(treeNode.getPath()));
    }

    public void setExpanded(SourceListCategory category, boolean expanded) {
        DefaultMutableTreeNode categoryNode = this.getNodeForObject(category);
        SourceList.checkCategoryNodeNotNull(categoryNode);
        TreeUtils.setExpandedOnEdt(this.fTree, new TreePath(categoryNode.getPath()), expanded);
    }

    public void setExpanded(SourceListItem item, boolean expanded) {
        DefaultMutableTreeNode itemNode = this.getNodeForObject(item);
        SourceList.checkItemNodeNotNull(itemNode);
        TreeUtils.setExpandedOnEdt(this.fTree, new TreePath(itemNode.getPath()), expanded);
    }

    private DefaultMutableTreeNode getNodeForObject(Object userObject) {
        return SourceList.getNodeForObject(this.fRoot, userObject);
    }

    private static DefaultMutableTreeNode getNodeForObject(DefaultMutableTreeNode parentNode, Object userObject) {
        if (parentNode.getUserObject().equals(userObject)) {
            return parentNode;
        }
        if (parentNode.children().hasMoreElements()) {
            for (int i2 = 0; i2 < parentNode.getChildCount(); ++i2) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)parentNode.getChildAt(i2);
                DefaultMutableTreeNode retVal = SourceList.getNodeForObject(childNode, userObject);
                if (retVal == null) continue;
                return retVal;
            }
        } else {
            return null;
        }
        return null;
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public SourceListModel getModel() {
        return this.fModel;
    }

    public void setToolTipProvider(SourceListToolTipProvider toolTipProvider) {
        if (toolTipProvider == null) {
            throw new IllegalArgumentException("SourceListToolTipProvider cannot be null.");
        }
        this.fToolTipProvider = toolTipProvider;
    }

    private void doAddCategory(SourceListCategory category, int index) {
        DefaultMutableTreeNode categoryNode = new DefaultMutableTreeNode(category);
        this.fTreeModel.insertNodeInto(categoryNode, this.fRoot, index);
        for (int i2 = 0; i2 < category.getItems().size(); ++i2) {
            this.doAddItemToCategory(category.getItems().get(i2), category, i2);
        }
        TreeUtils.expandPathOnEdt(this.fTree, new TreePath(categoryNode.getPath()));
    }

    private void doRemoveCategory(SourceListCategory category) {
        DefaultMutableTreeNode categoryNode = SourceList.getNodeForObject(this.fRoot, category);
        SourceList.checkCategoryNodeNotNull(categoryNode);
        this.fTreeModel.removeNodeFromParent(categoryNode);
    }

    private void doAddItemToCategory(SourceListItem itemToAdd, SourceListCategory category, int index) {
        DefaultMutableTreeNode categoryNode = SourceList.getNodeForObject(this.fRoot, category);
        SourceList.checkCategoryNodeNotNull(categoryNode);
        this.doAddItemToNode(itemToAdd, categoryNode, index);
    }

    private void doRemoveItemFromCategory(SourceListItem itemToRemove, SourceListCategory category) {
        DefaultMutableTreeNode categoryNode = SourceList.getNodeForObject(this.fRoot, category);
        SourceList.checkCategoryNodeNotNull(categoryNode);
        DefaultMutableTreeNode itemNode = SourceList.getNodeForObject(categoryNode, itemToRemove);
        SourceList.checkCategoryNodeNotNull(itemNode);
        this.fTreeModel.removeNodeFromParent(itemNode);
    }

    private void doAddItemToItem(SourceListItem itemToAdd, SourceListItem parentItem, int index) {
        DefaultMutableTreeNode parentItemNode = SourceList.getNodeForObject(this.fRoot, parentItem);
        SourceList.checkCategoryNodeNotNull(parentItemNode);
        this.doAddItemToNode(itemToAdd, parentItemNode, index);
    }

    private void doRemoveItemFromItem(SourceListItem itemToRemove, SourceListItem parentItem) {
        DefaultMutableTreeNode parentNode = SourceList.getNodeForObject(this.fRoot, parentItem);
        SourceList.checkCategoryNodeNotNull(parentNode);
        DefaultMutableTreeNode itemNode = SourceList.getNodeForObject(parentNode, itemToRemove);
        SourceList.checkCategoryNodeNotNull(itemNode);
        this.fTreeModel.removeNodeFromParent(itemNode);
    }

    private void doAddItemToNode(SourceListItem itemToAdd, DefaultMutableTreeNode parentNode, int index) {
        DefaultMutableTreeNode itemNode = new DefaultMutableTreeNode(itemToAdd);
        this.fTreeModel.insertNodeInto(itemNode, parentNode, index);
        for (int i2 = 0; i2 < itemToAdd.getChildItems().size(); ++i2) {
            this.doAddItemToItem(itemToAdd.getChildItems().get(i2), itemToAdd, i2);
        }
        if (parentNode.getChildCount() == 1) {
            TreeUtils.expandPathOnEdt(this.fTree, new TreePath(parentNode.getPath()));
        }
    }

    private void doItemChanged(SourceListItem item) {
        DefaultMutableTreeNode itemNode = SourceList.getNodeForObject(this.fRoot, item);
        SourceList.checkItemNodeNotNull(itemNode);
        this.fTreeModel.nodeChanged(itemNode);
    }

    private void doShowContextMenu(MouseEvent event) {
        Object itemOrCategory = this.getItemOrCategoryUnderPoint(event.getPoint());
        JPopupMenu popup = null;
        if (itemOrCategory == null) {
            popup = this.fContextMenuProvider.createContextMenu();
        } else if (itemOrCategory instanceof SourceListItem) {
            popup = this.fContextMenuProvider.createContextMenu((SourceListItem)itemOrCategory);
        } else if (itemOrCategory instanceof SourceListCategory) {
            popup = this.fContextMenuProvider.createContextMenu((SourceListCategory)itemOrCategory);
        }
        if (popup != null && popup.getComponentCount() > 0) {
            popup.show(this.fTree, event.getX(), event.getY());
        }
    }

    private void doSourceListClicked(MouseEvent event) {
        Object itemOrCategory = this.getItemOrCategoryUnderPoint(event.getPoint());
        SourceListClickListener.Button button = SourceListClickListener.Button.getButton(event.getButton());
        int clickCount = event.getClickCount();
        if (itemOrCategory != null) {
            if (itemOrCategory instanceof SourceListItem) {
                this.fireSourceListItemClicked((SourceListItem)itemOrCategory, button, clickCount);
            } else if (itemOrCategory instanceof SourceListCategory) {
                this.fireSourceListCategoryClicked((SourceListCategory)itemOrCategory, button, clickCount);
            }
        }
    }

    private Object getItemOrCategoryUnderPoint(Point point) {
        TreePath path = this.fTree.getPathForLocation(point.x, point.y);
        return path == null ? null : ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
    }

    private TreeSelectionListener createTreeSelectionListener() {
        return new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e2) {
                SourceList.this.fireSourceListItemSelected(SourceList.this.getSelectedItem());
            }
        };
    }

    private TreeExpansionListener createTreeExpansionListener() {
        return new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                this.onExpandedOrCollapsed(event, true);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                this.onExpandedOrCollapsed(event, false);
            }

            private void onExpandedOrCollapsed(TreeExpansionEvent event, boolean expanded) {
                Object itemOrCategory = SourceList.this.getItemOrCategoryFromTreeExpansionEvent(event);
                if (itemOrCategory != null) {
                    if (itemOrCategory instanceof SourceListCategory) {
                        SourceListCategory category = (SourceListCategory)itemOrCategory;
                        if (expanded) {
                            SourceList.this.fireSourceListCategoryExpanded(category);
                        } else {
                            SourceList.this.fireSourceListCategoryCollapsed(category);
                        }
                    } else if (itemOrCategory instanceof SourceListItem) {
                        SourceListItem sourceListItem = (SourceListItem)itemOrCategory;
                        if (expanded) {
                            SourceList.this.fireSourceListItemExpanded(sourceListItem);
                        } else {
                            SourceList.this.fireSourceListItemCollapsed(sourceListItem);
                        }
                    }
                }
            }
        };
    }

    private TreeWillExpandListener createTreeWillExpandListener() {
        return new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                this.onWillExpandOrCollapse(event, true);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                this.onWillExpandOrCollapse(event, false);
            }

            private void onWillExpandOrCollapse(TreeExpansionEvent event, boolean expanded) throws ExpandVetoException {
                Object itemOrCategory = SourceList.this.getItemOrCategoryFromTreeExpansionEvent(event);
                if (itemOrCategory != null) {
                    if (itemOrCategory instanceof SourceListCategory) {
                        SourceListCategory category = (SourceListCategory)itemOrCategory;
                        if (expanded) {
                            SourceList.this.fireSourceListCategoryWillExpand(event, category);
                        } else {
                            SourceList.this.fireSourceListCategoryWillCollapse(event, category);
                        }
                    } else if (itemOrCategory instanceof SourceListItem) {
                        SourceListItem sourceListItem = (SourceListItem)itemOrCategory;
                        if (expanded) {
                            SourceList.this.fireSourceListItemWillExpand(event, sourceListItem);
                        } else {
                            SourceList.this.fireSourceListItemWillCollapse(event, sourceListItem);
                        }
                    }
                }
            }
        };
    }

    private SourceListModelListener createSourceListModelListener() {
        return new SourceListModelListener(){

            @Override
            public void categoryAdded(SourceListCategory category, int index) {
                SourceList.this.doAddCategory(category, index);
            }

            @Override
            public void categoryRemoved(SourceListCategory category) {
                SourceList.this.doRemoveCategory(category);
            }

            @Override
            public void itemAddedToCategory(SourceListItem item, SourceListCategory category, int index) {
                SourceList.this.doAddItemToCategory(item, category, index);
            }

            @Override
            public void itemRemovedFromCategory(SourceListItem item, SourceListCategory category) {
                SourceList.this.doRemoveItemFromCategory(item, category);
            }

            @Override
            public void itemAddedToItem(SourceListItem item, SourceListItem parentItem, int index) {
                SourceList.this.doAddItemToItem(item, parentItem, index);
            }

            @Override
            public void itemRemovedFromItem(SourceListItem item, SourceListItem parentItem) {
                SourceList.this.doRemoveItemFromItem(item, parentItem);
            }

            @Override
            public void itemChanged(SourceListItem item) {
                SourceList.this.doItemChanged(item);
            }
        };
    }

    private MouseListener createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                if (e2.isPopupTrigger()) {
                    SourceList.this.doShowContextMenu(e2);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (e2.isPopupTrigger()) {
                    SourceList.this.doShowContextMenu(e2);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e2) {
                SourceList.this.doSourceListClicked(e2);
            }
        };
    }

    private Object getItemOrCategoryFromTreeExpansionEvent(TreeExpansionEvent event) {
        Object lastPathComponent = event.getPath().getLastPathComponent();
        return ((DefaultMutableTreeNode)lastPathComponent).getUserObject();
    }

    private void fireSourceListItemClicked(SourceListItem item, SourceListClickListener.Button button, int clickCount) {
        for (SourceListClickListener listener : this.fSourceListClickListeners) {
            listener.sourceListItemClicked(item, button, clickCount);
        }
    }

    private void fireSourceListCategoryClicked(SourceListCategory category, SourceListClickListener.Button button, int clickCount) {
        for (SourceListClickListener listener : this.fSourceListClickListeners) {
            listener.sourceListCategoryClicked(category, button, clickCount);
        }
    }

    public void addSourceListClickListener(SourceListClickListener listener) {
        this.fSourceListClickListeners.add(listener);
    }

    public void removeSourceListClickListener(SourceListClickListener listener) {
        this.fSourceListClickListeners.remove(listener);
    }

    private void fireSourceListItemSelected(SourceListItem item) {
        for (SourceListSelectionListener listener : this.fSourceListSelectionListeners) {
            listener.sourceListItemSelected(item);
        }
    }

    public void addSourceListSelectionListener(SourceListSelectionListener listener) {
        this.fSourceListSelectionListeners.add(listener);
    }

    public void removeSourceListSelectionListener(SourceListSelectionListener listener) {
        this.fSourceListSelectionListeners.remove(listener);
    }

    private void fireSourceListItemExpanded(SourceListItem item) {
        for (SourceListExpansionListener listener : this.fSourceListExpansionListeners) {
            listener.sourceListItemExpanded(item);
        }
    }

    private void fireSourceListItemCollapsed(SourceListItem item) {
        for (SourceListExpansionListener listener : this.fSourceListExpansionListeners) {
            listener.sourceListItemCollapsed(item);
        }
    }

    private void fireSourceListItemWillExpand(TreeExpansionEvent event, SourceListItem item) throws ExpandVetoException {
        for (SourceListExpansionListener listener : this.fSourceListExpansionListeners) {
            this.handleShouldExpandOrCollapseResponse(listener.shouldExpandSourceListItem(item), event);
        }
    }

    private void fireSourceListItemWillCollapse(TreeExpansionEvent event, SourceListItem item) throws ExpandVetoException {
        for (SourceListExpansionListener listener : this.fSourceListExpansionListeners) {
            this.handleShouldExpandOrCollapseResponse(listener.shouldCollapseSourceListItem(item), event);
        }
    }

    private void fireSourceListCategoryExpanded(SourceListCategory category) {
        for (SourceListExpansionListener listener : this.fSourceListExpansionListeners) {
            listener.sourceListCategoryExpanded(category);
        }
    }

    private void fireSourceListCategoryCollapsed(SourceListCategory category) {
        for (SourceListExpansionListener listener : this.fSourceListExpansionListeners) {
            listener.sourceListCategoryCollapsed(category);
        }
    }

    private void fireSourceListCategoryWillExpand(TreeExpansionEvent event, SourceListCategory category) throws ExpandVetoException {
        for (SourceListExpansionListener listener : this.fSourceListExpansionListeners) {
            this.handleShouldExpandOrCollapseResponse(listener.shouldExpandSourceListCategory(category), event);
        }
    }

    private void fireSourceListCategoryWillCollapse(TreeExpansionEvent event, SourceListCategory category) throws ExpandVetoException {
        for (SourceListExpansionListener listener : this.fSourceListExpansionListeners) {
            this.handleShouldExpandOrCollapseResponse(listener.shouldToCollapseSourceListCategory(category), event);
        }
    }

    private void handleShouldExpandOrCollapseResponse(boolean shouldExpandOrCollapse, TreeExpansionEvent event) throws ExpandVetoException {
        if (!shouldExpandOrCollapse) {
            throw new ExpandVetoException(event);
        }
    }

    public void addSourceListExpansionListener(SourceListExpansionListener listener) {
        this.fSourceListExpansionListeners.add(listener);
    }

    public void removeSourceListExpansionListener(SourceListExpansionListener listener) {
        this.fSourceListExpansionListeners.remove(listener);
    }

    private static void checkCategoryNodeNotNull(MutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("The given SourceListCategory does not exist in this SourceList.");
        }
    }

    private static void checkItemNodeNotNull(MutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("The given SourceListItem does not exist in this SourceList.");
        }
    }

    private static class EmptyToolTipProvider
    implements SourceListToolTipProvider {
        private EmptyToolTipProvider() {
        }

        @Override
        public String getTooltip(SourceListCategory category) {
            return null;
        }

        @Override
        public String getTooltip(SourceListItem item) {
            return null;
        }
    }

    private class CustomJTree
    extends JTree {
        public CustomJTree(TreeModel newModel) {
            super(newModel);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public void updateUI() {
            this.setUI(new SourceListTreeUI());
            this.invalidate();
        }

        @Override
        public void collapsePath(TreePath path) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object categoryOrItem = node.getUserObject();
            if (!(categoryOrItem instanceof SourceListCategory) || ((SourceListCategory)categoryOrItem).isCollapsable()) {
                super.collapsePath(path);
            }
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            TreePath path = this.getPathForLocation(event.getX(), event.getY());
            Object userObject = path == null ? null : ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            String toolTipText = null;
            if (userObject instanceof SourceListCategory) {
                toolTipText = SourceList.this.fToolTipProvider.getTooltip((SourceListCategory)userObject);
            } else if (userObject instanceof SourceListItem) {
                toolTipText = SourceList.this.fToolTipProvider.getTooltip((SourceListItem)userObject);
            }
            return toolTipText;
        }
    }

    private static class EmptySourceListContextMenuProvider
    implements SourceListContextMenuProvider {
        private EmptySourceListContextMenuProvider() {
        }

        @Override
        public JPopupMenu createContextMenu() {
            return null;
        }

        @Override
        public JPopupMenu createContextMenu(SourceListItem item) {
            return null;
        }

        @Override
        public JPopupMenu createContextMenu(SourceListCategory category) {
            return null;
        }
    }
}

