/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.macwidgets;

import com.jtechdev.macwidgets.ComponentBottomBar;
import com.jtechdev.macwidgets.plaf.PreferencesTabBarButtonUI;
import com.jtechdev.macwidgets.plaf.UnifiedToolbarButtonUI;
import com.jtechdev.painter.ButtonStatePainter;
import com.jtechdev.painter.CompoundPainter;
import com.jtechdev.painter.ImagePainter;
import com.jtechdev.painter.MacWidgetsPainter;
import com.jtechdev.painter.RectanglePainter;
import com.jtechdev.swingx.EPButton;
import com.jtechdev.widgets.PopdownButton;
import com.jtechdev.widgets.PopupMenuCustomizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;

public class MacButtonFactory {
    static final Color GRADIENT_BUTTON_BORDER_COLOR = new Color(190, 190, 190);
    private static URL GRADIENT_BACKGROUND_URL = ComponentBottomBar.class.getResource("/com/jtechdev/macwidgets/images/component_status_bar_shiny_background_no_border.png");
    static final ImagePainter GRADIENT_BUTTON_IMAGE_PAINTER = new ImagePainter(GRADIENT_BACKGROUND_URL);
    private static final MacWidgetsPainter<Component> PRESSED_AND_SELECTED_GRADIENT_PAINTER = new CompoundPainter<Component>(GRADIENT_BUTTON_IMAGE_PAINTER, new RectanglePainter(new Color(0, 0, 0, 89)));
    private static final ButtonStatePainter<AbstractButton> GRADIENT_BUTTON_PAINTER = new ButtonStatePainter(GRADIENT_BUTTON_IMAGE_PAINTER, GRADIENT_BUTTON_IMAGE_PAINTER, PRESSED_AND_SELECTED_GRADIENT_PAINTER, PRESSED_AND_SELECTED_GRADIENT_PAINTER);

    public static AbstractButton makeUnifiedToolBarButton(AbstractButton button) {
        button.setUI(new UnifiedToolbarButtonUI());
        return button;
    }

    public static AbstractButton makePreferencesTabBarButton(AbstractButton button) {
        button.setUI(new PreferencesTabBarButtonUI());
        return button;
    }

    public static MacWidgetsPainter<Component> getGradientButtonPainter() {
        return GRADIENT_BUTTON_IMAGE_PAINTER;
    }

    public static JComponent createGradientButton(Icon icon, ActionListener actionListener) {
        EPButton button = new EPButton(icon);
        button.addActionListener(actionListener);
        button.setBackgroundPainter(GRADIENT_BUTTON_PAINTER);
        MacButtonFactory.initGradientButton(button);
        button.setPressedIcon(icon);
        return button;
    }

    public static JComponent createGradientButton(String text, ActionListener actionListener) {
        EPButton button = new EPButton(text);
        button.addActionListener(actionListener);
        button.setBackgroundPainter(GRADIENT_BUTTON_PAINTER);
        MacButtonFactory.initGradientButton(button);
        return button;
    }

    public static PopdownButton createGradientPopdownButton(Icon icon, PopupMenuCustomizer popupMenuCustomizer) {
        PopdownButton popdownButton = new PopdownButton(icon, popupMenuCustomizer);
        popdownButton.setBackgroundPainter(GRADIENT_BUTTON_PAINTER);
        MacButtonFactory.initGradientButton(popdownButton.getComponent());
        popdownButton.setPressedIcon(icon);
        return popdownButton;
    }

    private static void initGradientButton(JComponent button) {
        button.setBorder(BorderFactory.createLineBorder(GRADIENT_BUTTON_BORDER_COLOR));
        button.setPreferredSize(new Dimension(30, 22));
    }
}

