/*
 * Decompiled with CFR 0.152.
 */
package com.jtechdev.macwidgets;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jtechdev.macwidgets.MacFontUtils;
import com.jtechdev.macwidgets.MacWidgetFactory;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LabeledComponentGroup {
    private JComponent fComponent;

    public LabeledComponentGroup(String labelString, JComponent ... components) {
        this(labelString, Arrays.asList(components));
    }

    public LabeledComponentGroup(String labelString, List<JComponent> components) {
        this.init(labelString, components);
    }

    public LabeledComponentGroup(String labelString, ButtonGroup group) {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        Enumeration<AbstractButton> e2 = group.getElements();
        while (e2.hasMoreElements()) {
            AbstractButton element = e2.nextElement();
            list.add(element);
        }
        this.init(labelString, list);
    }

    protected void init(String labelString, List<JComponent> components) {
        JComponent componentToAdd;
        if (components.size() == 1) {
            componentToAdd = components.get(0);
        } else {
            componentToAdd = new JPanel(new FlowLayout(0, 0, 1));
            componentToAdd.setOpaque(false);
            for (JComponent component : components) {
                componentToAdd.add(component);
            }
        }
        FormLayout layout = new FormLayout("p", "fill:p:grow, p");
        CellConstraints cc2 = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(layout, new JPanel());
        builder.add((Component)componentToAdd, cc2.xy(1, 1, "center, center"));
        builder.add((Component)this.createLabel(labelString), cc2.xy(1, 2, "center, top"));
        this.fComponent = builder.getPanel();
        this.fComponent.setOpaque(false);
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private JLabel createLabel(String labelString) {
        JLabel label = MacWidgetFactory.makeEmphasizedLabel(new JLabel(labelString));
        label.setFont(MacFontUtils.TOOLBAR_LABEL_FONT);
        return label;
    }
}

