/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.composite;

import com.jhlabs.composite.RGBComposite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;

public final class NegationComposite
extends RGBComposite {
    public NegationComposite(float alpha) {
        super(alpha);
    }

    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return new Context(this.extraAlpha, srcColorModel, dstColorModel);
    }

    static class Context
    extends RGBComposite.RGBCompositeContext {
        public Context(float alpha, ColorModel srcColorModel, ColorModel dstColorModel) {
            super(alpha, srcColorModel, dstColorModel);
        }

        public void composeRGB(int[] src, int[] dst, float alpha) {
            int w2 = src.length;
            for (int i2 = 0; i2 < w2; i2 += 4) {
                int sr = src[i2];
                int dir = dst[i2];
                int sg = src[i2 + 1];
                int dig = dst[i2 + 1];
                int sb2 = src[i2 + 2];
                int dib = dst[i2 + 2];
                int sa = src[i2 + 3];
                int dia = dst[i2 + 3];
                int dor = 255 - Math.abs(255 - sr - dir);
                int dog = 255 - Math.abs(255 - sg - dig);
                int dob = 255 - Math.abs(255 - sb2 - dib);
                float a2 = alpha * (float)sa / 255.0f;
                float ac2 = 1.0f - a2;
                dst[i2] = (int)(a2 * (float)dor + ac2 * (float)dir);
                dst[i2 + 1] = (int)(a2 * (float)dog + ac2 * (float)dig);
                dst[i2 + 2] = (int)(a2 * (float)dob + ac2 * (float)dib);
                dst[i2 + 3] = (int)((float)sa * alpha + (float)dia * ac2);
            }
        }
    }
}

