/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.DatelineModelVetoException;
import com.dlsc.flexgantt.model.dateline.IDatelineModelListener;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.timeline.TimeGranularityDatelineModel;
import javax.swing.BoundedRangeModel;

public class MultiGanttChartSynchController
implements IDatelineModelListener {
    private GanttChart[] gantt;
    private boolean processingEvent;

    public MultiGanttChartSynchController(GanttChart ... ganttCharts) {
        this.gantt = ganttCharts;
        BoundedRangeModel scrollModel = ganttCharts[0].getLayerContainerScrollPane().getHorizontalScrollBar().getModel();
        for (int i2 = 0; i2 < ganttCharts.length; ++i2) {
            ganttCharts[i2].getDateline().getModel().addDatelineModelListener(this);
            if (i2 <= 0) continue;
            ganttCharts[i2].getLayerContainerScrollPane().getHorizontalScrollBar().setModel(scrollModel);
        }
    }

    @Override
    public void datelineModelWillChange(DatelineModelEvent evt) throws DatelineModelVetoException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void datelineModelChanged(DatelineModelEvent evt) {
        if (this.processingEvent) return;
        try {
            this.processingEvent = true;
            switch (evt.getId()) {
                case REQUESTED_VISIBLE_TIME_SPAN_CHANGED: {
                    this.adjustRequestedVisibleTimeSpan(evt);
                    return;
                }
                case GRANULARITY_CHANGED: {
                    this.adjustGranularity(evt);
                    return;
                }
                case SELECTED_TIME_SPAN_CHANGED: {
                    this.adjustSelectedTimeSpan(evt);
                    return;
                }
                case ZOOM_CHANGED: {
                    this.adjustZoom(evt);
                    return;
                }
                case TIME_SPAN_CHANGED: {
                    this.adjustTimeSpan(evt);
                    return;
                }
            }
            return;
        }
        catch (DatelineModelException e2) {
            e2.printStackTrace();
            return;
        }
        finally {
            this.processingEvent = false;
        }
    }

    private void adjustRequestedVisibleTimeSpan(DatelineModelEvent evt) throws DatelineModelException {
        ITimeSpan span = evt.getRequestedVisibleTimeSpan();
        for (GanttChart g2 : this.gantt) {
            TimeGranularityDatelineModel model = (TimeGranularityDatelineModel)g2.getDatelineModel();
            if (model.equals(evt.getModel())) continue;
            model.requestVisibleTimeSpan(span);
        }
    }

    private void adjustTimeSpan(DatelineModelEvent evt) throws DatelineModelException {
        ITimeSpan span = evt.getModel().getTimeSpan();
        for (GanttChart g2 : this.gantt) {
            TimeGranularityDatelineModel model = (TimeGranularityDatelineModel)g2.getDatelineModel();
            if (model.equals(evt.getModel())) continue;
            model.setTimeSpan(span);
        }
    }

    private void adjustSelectedTimeSpan(DatelineModelEvent evt) {
        ITimeSpan span = evt.getModel().getSelectedTimeSpan();
        for (GanttChart g2 : this.gantt) {
            TimeGranularityDatelineModel model = (TimeGranularityDatelineModel)g2.getDatelineModel();
            if (model.equals(evt.getModel())) continue;
            model.setSelectedTimeSpan(span);
        }
    }

    private void adjustZoom(DatelineModelEvent evt) throws DatelineModelException {
        double zoom = evt.getModel().getZoom();
        for (GanttChart g2 : this.gantt) {
            TimeGranularityDatelineModel model = (TimeGranularityDatelineModel)g2.getDatelineModel();
            if (model.equals(evt.getModel())) continue;
            model.setZoom(zoom);
        }
    }

    private void adjustGranularity(DatelineModelEvent evt) throws DatelineModelException {
        TimeGranularity granularity = (TimeGranularity)evt.getModel().getGranularity();
        for (GanttChart g2 : this.gantt) {
            TimeGranularityDatelineModel model = (TimeGranularityDatelineModel)g2.getDatelineModel();
            if (model.equals(evt.getModel())) continue;
            model.setGranularity(granularity);
        }
    }
}

