/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.util;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class AutoscrollSupport
implements Autoscroll {
    private JComponent comp;
    private Insets insets;
    private Insets scrollUnits;

    public AutoscrollSupport(JComponent comp) {
        this(comp, new Insets(50, 50, 50, 50));
    }

    public AutoscrollSupport(JComponent comp, Insets insets) {
        this(comp, insets, insets);
    }

    public AutoscrollSupport(JComponent comp, Insets insets, Insets scrollUnits) {
        this.comp = comp;
        this.insets = insets;
        this.scrollUnits = scrollUnits;
    }

    @Override
    public void autoscroll(Point cursorLoc) {
        JViewport viewport = this.getViewport();
        if (viewport == null) {
            return;
        }
        Point viewPos = viewport.getViewPosition();
        int viewHeight = viewport.getExtentSize().height;
        int viewWidth = viewport.getExtentSize().width;
        Rectangle rect = this.comp.getVisibleRect();
        if (cursorLoc.y - viewPos.y < this.insets.top) {
            rect.translate(0, -this.scrollUnits.top);
        } else if (viewPos.y + viewHeight - cursorLoc.y < this.insets.bottom) {
            rect.translate(0, this.scrollUnits.bottom);
        } else if (cursorLoc.x - viewPos.x < this.insets.left) {
            rect.translate(-this.scrollUnits.left, 0);
        } else if (viewPos.x + viewWidth - cursorLoc.x < this.insets.right) {
            rect.translate(this.scrollUnits.right, 0);
        }
        if (!this.comp.getVisibleRect().equals(rect)) {
            this.comp.scrollRectToVisible(rect);
        }
    }

    @Override
    public Insets getAutoscrollInsets() {
        int height = this.comp.getHeight();
        int width = this.comp.getWidth();
        return new Insets(height, width, height, width);
    }

    private JViewport getViewport() {
        return (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.comp);
    }
}

