/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.treetable;

import com.dlsc.flexgantt.command.CommandStackEvent;
import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.ICommandStack;
import com.dlsc.flexgantt.command.ICommandStackListener;
import com.dlsc.flexgantt.model.treetable.ITreeTableModel;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.treetable.INodeDragAndDropPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.treetable.ITreeTableCellRenderer;
import com.dlsc.flexgantt.swing.treetable.TreeTable;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;

public class TreeTableDragAndDropManager
implements DragSourceListener,
DropTargetListener,
DragGestureListener,
ICommandStackListener,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(TreeTableDragAndDropManager.class.getName());
    private static DataFlavor localObjectFlavor;
    private int dropRow = -1;
    private TreeTableNode draggedNode;
    private Point dragLocation;
    private TreeTable table;
    private ICommand dndCommand;
    private TreePath dropPath;
    private boolean validDropLocation;

    public TreeTableDragAndDropManager(TreeTable table) {
        this.table = table;
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(table, 3, this);
        new DropTarget(table, 3, this, true);
        AbstractGanttChart gc2 = table.getGanttChart();
        gc2.addPropertyChangeListener(this);
        gc2.getCommandStack().addCommandStackListener(this);
    }

    public TreeTable getTreeTable() {
        return this.table;
    }

    @Override
    public void dragEnter(DragSourceDragEvent e2) {
        LOGGER.entering(TreeTableDragAndDropManager.class.getName(), "dragEnter(DragSourceDragEvent)");
        LOGGER.exiting(TreeTableDragAndDropManager.class.getName(), "dragEnter(DragSourceDragEvent)");
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        LOGGER.entering(TreeTableDragAndDropManager.class.getName(), "dragOver(DragSourceDragEvent)");
        LOGGER.exiting(TreeTableDragAndDropManager.class.getName(), "dragOver(DragSourceDragEvent)");
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
        LOGGER.entering(TreeTableDragAndDropManager.class.getName(), "dropActionChanged(DropTargetDragEvent)");
        LOGGER.exiting(TreeTableDragAndDropManager.class.getName(), "dropActionChanged(DropTargetDragEvent)");
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        LOGGER.entering(TreeTableDragAndDropManager.class.getName(), "dragExit(DragSourceEvent)");
        this.draggedNode = null;
        this.table.repaint();
        LOGGER.exiting(TreeTableDragAndDropManager.class.getName(), "dragExit(DragSourceEvent)");
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e2) {
        LOGGER.entering(TreeTableDragAndDropManager.class.getName(), "dragDropEnd(DragSourceDropEvent)");
        this.dropRow = -1;
        this.draggedNode = null;
        this.dragLocation = null;
        this.table.repaint();
        LOGGER.exiting(TreeTableDragAndDropManager.class.getName(), "dragDropEnd(DragSourceDropEvent)");
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        LOGGER.entering(TreeTableDragAndDropManager.class.getName(), "dragEnter(DropTargetDragEvent)");
        if (!this.isDragOK(dtde)) {
            dtde.rejectDrag();
            return;
        }
        dtde.acceptDrag(dtde.getDropAction());
        LOGGER.exiting(TreeTableDragAndDropManager.class.getName(), "dragEnter(DropTargetDragEvent)");
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        LOGGER.entering(TreeTableDragAndDropManager.class.getName(), "dragOver(DropTargetDragEvent)");
        if (!this.isDragOK(dtde)) {
            dtde.rejectDrag();
            return;
        }
        dtde.acceptDrag(dtde.getDropAction());
        LOGGER.exiting(TreeTableDragAndDropManager.class.getName(), "dragOver(DropTargetDragEvent)");
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        LOGGER.entering(TreeTableDragAndDropManager.class.getName(), "dropActionChanged(DropTargetDragEvent)");
        if (!this.isDragOK(dtde)) {
            dtde.rejectDrag();
            return;
        }
        dtde.acceptDrag(dtde.getDropAction());
        LOGGER.exiting(TreeTableDragAndDropManager.class.getName(), "dropActionChanged(DropTargetDragEvent)");
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        LOGGER.entering(TreeTableDragAndDropManager.class.getName(), "dragExit(DropTargetEvent)");
        this.draggedNode = null;
        this.table.repaint();
        LOGGER.exiting(TreeTableDragAndDropManager.class.getName(), "dragExit(DropTargetEvent)");
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        LOGGER.entering(TreeTableDragAndDropManager.class.getName(), "drop(DropTargetDropEvent)");
        try {
            Object transferable;
            if (dtde.isDataFlavorSupported(localObjectFlavor) && (transferable = dtde.getTransferable().getTransferData(localObjectFlavor)) instanceof TreeTableNode) {
                TreeTableNode transferedNode = (TreeTableNode)transferable;
                ITreeTableModel sourceModel = transferedNode.getTreeTable().getModel();
                LOGGER.log(Level.FINE, "source model = " + sourceModel);
                Object draggedObject = transferedNode.getModelNode();
                LOGGER.log(Level.FINE, "dragged object = " + draggedObject);
                Point dragPoint = dtde.getLocation();
                this.dropRow = this.table.getRowAt((int)dragPoint.getY());
                if (this.dropRow == -1) {
                    LOGGER.log(Level.FINE, "rejecting drop: invalid drop row");
                    this.draggedNode = null;
                    this.dragLocation = null;
                    this.dropRow = -1;
                    this.table.repaint();
                    dtde.rejectDrop();
                } else {
                    List<TreeTableNode> nodes = this.table.getTreeTableNodes();
                    TreeTableNode targetTreeNode = nodes.get(this.dropRow);
                    this.dropPath = targetTreeNode.getPath();
                    Object targetParent = targetTreeNode.getModelNode();
                    ITreeTableModel targetModel = targetTreeNode.getTreeTable().getModel();
                    IPolicyProvider policyProvider = this.table.getPolicyProvider();
                    INodeDragAndDropPolicy dnd = policyProvider.getPolicy(INodeDragAndDropPolicy.class);
                    LOGGER.log(Level.FINE, "target node = " + targetTreeNode);
                    LOGGER.log(Level.FINE, "target model = " + targetModel);
                    LOGGER.log(Level.FINE, "dnd policy = " + dnd);
                    Object sourceParent = null;
                    if (transferedNode.getParentNode() == null) {
                        LOGGER.log(Level.WARNING, "root of tree table can not be dragged");
                        dtde.rejectDrop();
                        LOGGER.exiting(TreeTableDragAndDropManager.class.getName(), "drop(DropTargetDropEvent)");
                        return;
                    }
                    sourceParent = transferedNode.getParentNode().getModelNode();
                    int acceptedActions = dnd.getDropActions(draggedObject, sourceParent, sourceModel, targetParent, targetModel);
                    int sourceActions = dtde.getSourceActions();
                    if ((sourceActions & acceptedActions) == 0) {
                        dtde.rejectDrop();
                        this.draggedNode = null;
                        this.dragLocation = null;
                        this.dropRow = -1;
                        this.table.repaint();
                        return;
                    }
                    dtde.acceptDrop(acceptedActions);
                    int sourceIndex = sourceModel.getIndexOfChild(sourceParent, draggedObject);
                    int targetIndex = targetModel.getChildCount(targetParent);
                    LOGGER.fine("setting initial child indices");
                    LOGGER.fine("source index = " + sourceIndex);
                    LOGGER.fine("target index = " + targetIndex + " (default is LAST child)");
                    if (targetTreeNode.isLeaf()) {
                        TreeTableNode targetParentNode = targetTreeNode.getParentNode();
                        this.dropPath = targetParentNode.getPath();
                        targetParent = targetParentNode.getModelNode();
                        targetIndex = targetModel.getIndexOfChild(targetParent, targetTreeNode.getModelNode()) + 1;
                    } else {
                        targetIndex = 0;
                    }
                    if (targetParent.equals(sourceParent) && targetIndex > sourceIndex) {
                        --targetIndex;
                    }
                    this.dropPath = this.dropPath.pathByAddingChild(draggedObject);
                    this.dndCommand = dnd.getDragAndDropCommand(draggedObject, sourceParent, sourceModel, sourceIndex, targetParent, targetModel, targetIndex, dtde.getDropAction());
                    this.table.getGanttChart().commandExecute(this.dndCommand);
                    dtde.getDropTargetContext().dropComplete(true);
                }
            }
        }
        catch (UnsupportedFlavorException e2) {
            LOGGER.log(Level.WARNING, "error during drop", e2);
        }
        catch (IOException e3) {
            LOGGER.log(Level.WARNING, "error during drop", e3);
        }
        this.draggedNode = null;
        this.dragLocation = null;
        this.dropRow = -1;
        this.table.repaint();
        LOGGER.exiting(TreeTableDragAndDropManager.class.getName(), "drop(DropTargetDropEvent)");
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        LOGGER.entering(TreeTableDragAndDropManager.class.getName(), "dragGestureRecognized(DragGestureEvent)");
        if (this.table.isDraggingEnabled() && this.table.getCursor() != TreeTable.INDENT_CURSOR) {
            this.table.getCellFocusManager().looseFocus();
            Point clickPoint = dge.getDragOrigin();
            int dragRow = this.table.getRowAt(clickPoint.y);
            if (dragRow != -1) {
                LOGGER.fine("drag row = " + dragRow);
                IPolicyProvider policyProvider = this.table.getPolicyProvider();
                ITreeTableModel model = this.table.getModel();
                List<TreeTableNode> nodes = this.table.getTreeTableNodes();
                INodeDragAndDropPolicy dnd = policyProvider.getPolicy(INodeDragAndDropPolicy.class);
                int userDragAction = dge.getDragAction();
                LOGGER.fine("user drag action = " + userDragAction);
                TreeTableNode node = nodes.get(dragRow);
                int supportedActions = dnd.getDragActions(node.getModelNode(), model);
                LOGGER.fine("supported actions = " + supportedActions);
                if ((userDragAction & supportedActions) != 0) {
                    TreeTableTransferable trans = new TreeTableTransferable(node);
                    Image img = new BufferedImage(1, 1, 2);
                    Point imgOffset = new Point(0, 0);
                    if (DragSource.isDragImageSupported()) {
                        LOGGER.fine("drag cursor is supported");
                        img = this.createDragImage(node);
                        imgOffset = new Point(-img.getWidth(this.table) / 2, -img.getHeight(this.table) / 2);
                    } else {
                        LOGGER.fine("custom drag image is not supported");
                    }
                    dge.startDrag(null, img, imgOffset, trans, this);
                    this.table.clearSelection();
                    this.table.repaint();
                }
            }
        }
        LOGGER.exiting(TreeTableDragAndDropManager.class.getName(), "dragGestureRecognized(DragGestureEvent)");
    }

    public int getDropRow() {
        return this.dropRow;
    }

    public TreeTableNode getDraggedNode() {
        return this.draggedNode;
    }

    public Point getDragLocation() {
        return this.dragLocation;
    }

    protected Image createDragImage(TreeTableNode node) {
        LOGGER.entering(TreeTableDragAndDropManager.class.getName(), "createDragImage");
        ITreeTableModel model = this.table.getModel();
        Object modelNode = node.getModelNode();
        Object key = model.getKey(modelNode);
        LOGGER.fine("key = " + key);
        boolean leaf = model.isLeaf(modelNode);
        LOGGER.fine("leaf = " + leaf);
        Class<?> cl = this.table.getKeyColumn().getColumnClass();
        if (key != null) {
            cl = key.getClass();
        }
        ITreeTableCellRenderer renderer = this.table.getCellRenderer(cl);
        LOGGER.fine("renderer = " + renderer);
        JComponent comp = (JComponent)renderer.getTreeTableCellRendererComponent(this.table, modelNode, key, 0, false, false, leaf, 0, Integer.MIN_VALUE, false);
        LOGGER.fine("comp = " + comp);
        Dimension dim = comp.getPreferredSize();
        LOGGER.fine("dim = " + dim);
        CellRendererPane rendererPane = this.table.getRendererPane();
        BufferedImage image = new BufferedImage(dim.width, dim.height, 2);
        Graphics g2 = image.getGraphics();
        rendererPane.paintComponent(g2, comp, this.table, 0, 0, dim.width, dim.height, true);
        LOGGER.exiting(TreeTableDragAndDropManager.class.getName(), "createDragImage");
        return image;
    }

    @Override
    public void commandStackChanged(CommandStackEvent e2) {
        ICommand cmd = e2.getCommand();
        if (cmd.equals(this.dndCommand)) {
            switch (e2.getId()) {
                default: 
            }
            this.table.repaint();
            this.table.getRowHeader().repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.table.getGanttChart()) && evt.getPropertyName().equals("commandStack")) {
            ICommandStack oldStack = (ICommandStack)evt.getOldValue();
            ICommandStack newStack = (ICommandStack)evt.getNewValue();
            if (oldStack != null) {
                oldStack.removeCommandStackListener(this);
            }
            if (newStack != null) {
                newStack.addCommandStackListener(this);
            }
        }
    }

    public boolean isDragOK(DropTargetDragEvent dtde) {
        this.validDropLocation = true;
        try {
            if (!this.table.isDroppingEnabled() || !dtde.isDataFlavorSupported(localObjectFlavor)) {
                return false;
            }
            Object transferedObject = dtde.getTransferable().getTransferData(localObjectFlavor);
            if (transferedObject instanceof TreeTableNode) {
                this.draggedNode = (TreeTableNode)transferedObject;
                this.dragLocation = dtde.getLocation();
                this.dropRow = this.table.getRowAt((int)this.dragLocation.getY());
                if (this.dropRow == -1) {
                    this.validDropLocation = false;
                }
                if (this.table.isCreationEnabled() && this.dropRow == this.table.getRowCount() - 1) {
                    this.validDropLocation = false;
                }
                if (this.validDropLocation) {
                    List<TreeTableNode> nodes = this.table.getTreeTableNodes();
                    TreeTableNode targetNode = nodes.get(this.dropRow);
                    if (targetNode == this.draggedNode) {
                        this.validDropLocation = false;
                    }
                    if (this.validDropLocation) {
                        Object targetParent = targetNode.getModelNode();
                        if (targetNode.isLeaf()) {
                            targetParent = this.table.getRootNode().equals(targetNode) ? null : targetNode.getParentNode().getModelNode();
                        }
                        IPolicyProvider policyProvider = this.table.getPolicyProvider();
                        INodeDragAndDropPolicy dnd = policyProvider.getPolicy(INodeDragAndDropPolicy.class);
                        Object parentModelNode = null;
                        TreeTableNode parentNode = this.draggedNode.getParentNode();
                        if (parentNode != null) {
                            parentModelNode = parentNode.getModelNode();
                        }
                        int sourceActions = dtde.getSourceActions();
                        int acceptedActions = dnd.getDropActions(this.draggedNode.getModelNode(), parentModelNode, this.draggedNode.getModel(), targetParent, nodes.get(this.dropRow).getModel());
                        if ((acceptedActions & sourceActions) == 0) {
                            this.validDropLocation = false;
                        }
                    }
                }
            }
        }
        catch (UnsupportedFlavorException e2) {
            LOGGER.log(Level.WARNING, "error during drop", e2);
        }
        catch (IOException e3) {
            LOGGER.log(Level.WARNING, "error during drop", e3);
        }
        this.table.repaint();
        if (this.validDropLocation) {
            LOGGER.fine("drag is OK");
        } else {
            LOGGER.fine("drag is NOT OK");
        }
        return this.validDropLocation;
    }

    public boolean isValidDropLocation() {
        return this.validDropLocation;
    }

    static {
        try {
            localObjectFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException e2) {
            LOGGER.log(Level.WARNING, "error while creating DataFlavor.javaJVMLocalObjectMimeType", e2);
        }
    }

    static class TreeTableTransferable
    implements Transferable {
        private TreeTableNode node;

        public TreeTableTransferable(TreeTableNode node) {
            this.node = node;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{localObjectFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(localObjectFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (this.isDataFlavorSupported(flavor)) {
                return this.node;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

