/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.dateline.IZoomPolicy;
import com.dlsc.flexgantt.swing.timeline.AbstractTimelineControlPanel;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.TimeGranularityDatelineModel;
import com.dlsc.flexgantt.swing.timeline.TimeGranularityListCellRenderer;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class TimeGranularityTimelineControlPanel
extends AbstractTimelineControlPanel<TimeGranularity> {
    private static final Logger LOGGER = Logger.getLogger(TimeGranularityTimelineControlPanel.class.getName());

    public TimeGranularityTimelineControlPanel(Timeline timeline, boolean showGranularity) {
        super(timeline, showGranularity);
        this.getGranularityBox().setRenderer(new TimeGranularityListCellRenderer());
        this.updateControlPanel();
    }

    public TimeGranularityTimelineControlPanel(Timeline timeline) {
        this(timeline, true);
    }

    @Override
    public void updateControlPanel() {
        Dateline dateline = this.getTimeline().getDateline();
        IDatelineModel model = dateline.getModel();
        if (model instanceof TimeGranularityDatelineModel) {
            TimeGranularityDatelineModel tgModel = (TimeGranularityDatelineModel)dateline.getModel();
            this.setGranularity((TimeGranularity)tgModel.getGranularity());
            this.setTimeSpan(this.getTimeline().getDateline().getTimeSpan());
        }
    }

    @Override
    protected void setTimeSpan(ITimeSpan span) {
        this.getStartTimeModel().setValue(new Date(span.getStartTime()));
        this.getEndTimeModel().setValue(new Date(span.getEndTime()));
    }

    @Override
    public ITimeSpan getTimeSpan() {
        Date from = (Date)this.getStartTimeModel().getValue();
        Date to = (Date)this.getEndTimeModel().getValue();
        return new TimeSpan(from, to);
    }

    @Override
    public boolean isValidSettings() {
        Date from = (Date)this.getStartTimeModel().getValue();
        Date to = (Date)this.getEndTimeModel().getValue();
        return from.getTime() <= to.getTime();
    }

    @Override
    protected SpinnerModel createStartTimeModel() {
        return new SpinnerDateModel();
    }

    @Override
    protected SpinnerModel createEndTimeModel() {
        return new SpinnerDateModel();
    }

    @Override
    protected ComboBoxModel createGranularityModel() {
        Timeline timeline = this.getTimeline();
        Dateline dateline = timeline.getDateline();
        IPolicyProvider pp = dateline.getPolicyProvider();
        IZoomPolicy zp = pp.getPolicy(IZoomPolicy.class);
        int count = zp.getGranularityCount();
        Vector granularities = new Vector(count);
        for (int i2 = 0; i2 < count; ++i2) {
            granularities.add(zp.getGranularity(i2));
        }
        return new DefaultComboBoxModel(granularities);
    }

    @Override
    public void applySettings() {
        TimeGranularity tg = (TimeGranularity)this.getGranularityBox().getSelectedItem();
        TimeGranularityDatelineModel model = (TimeGranularityDatelineModel)this.getTimeline().getDateline().getModel();
        try {
            model.setTimeSpan(this.getTimeSpan());
            model.setGranularity(tg);
        }
        catch (DatelineModelException ex) {
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Messages.getString("TimeGranularityTimelineControlPanel.UNABLE_TO_FULFILL_REQUEST"), Messages.getString("TimeGranularityTimelineControlPanel.ERROR_DIALOG_TITLE"), 0);
            LOGGER.throwing("TimeGranularityTimelineControlpanel", "actionPerformed", ex);
        }
    }

    public static void openDialog(Component comp, Timeline timeline) {
        if (comp == null) {
            throw new IllegalArgumentException("parent component can not be NULL");
        }
        if (timeline == null) {
            throw new IllegalArgumentException("timeline can not be NULL");
        }
        TimeGranularityTimelineControlPanel panel = new TimeGranularityTimelineControlPanel(timeline);
        panel.setBorder(new EmptyBorder(20, 20, 20, 20));
        Dialog dialog = null;
        Window window = SwingUtilities.getWindowAncestor(comp);
        if (window instanceof Frame) {
            dialog = new JDialog((Frame)window, Messages.getString("TimeGranularityTimelineControlPanel.DIALOG_TITLE"), true);
        } else if (window instanceof Dialog) {
            dialog = new JDialog((Dialog)window, Messages.getString("TimeGranularityTimelineControlPanel.DIALOG_TITLE"), true);
        }
        if (dialog != null) {
            dialog.setModal(true);
            dialog.add("Center", panel);
            dialog.pack();
            dialog.setResizable(false);
            dialog.setLocationRelativeTo(comp);
            dialog.setVisible(true);
        }
    }
}

