/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.timeline;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.calendar.HolidayCalendarEntry;
import com.dlsc.flexgantt.model.calendar.ICalendarModel;
import com.dlsc.flexgantt.model.calendar.WeekendCalendarEntry;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.timeline.IDatelineRenderer;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;

public abstract class AbstractDatelineRenderer<T extends IDatelineModel>
extends JLabel
implements IDatelineRenderer<T> {
    private Map<Class, Color> foregroundMap;
    private Map<Class, Color> backgroundMap;
    private Color focusForeground = ColorUtil.getFocusForeground();
    private Color focusBackground = ColorUtil.getFocusBackground();
    private boolean focus;
    private boolean major;
    private ITimeSpan timeSpan;
    private Dateline dateline;
    private T model;
    private String text;
    private Icon icon;
    private boolean focusedTimeVisible;

    protected AbstractDatelineRenderer() {
        this.setLayout(null);
        this.setHorizontalAlignment(0);
        this.foregroundMap = new HashMap<Class, Color>();
        this.backgroundMap = new HashMap<Class, Color>();
        this.setCalendarEntryForeground(WeekendCalendarEntry.class, Color.WHITE);
        this.setCalendarEntryBackground(WeekendCalendarEntry.class, Color.RED);
        this.setCalendarEntryForeground(HolidayCalendarEntry.class, Color.BLACK);
        this.setCalendarEntryBackground(HolidayCalendarEntry.class, Color.ORANGE);
    }

    public void setFocusedTimeVisible(boolean visible) {
        this.focusedTimeVisible = visible;
    }

    public boolean isFocusedTimeVisible() {
        return this.focusedTimeVisible;
    }

    @Override
    public Component getDatelineRendererComponent(Dateline dateline, T model, ITimeSpan timeSpan, boolean major, boolean focus) {
        this.setFont(dateline.getFont());
        this.setEnabled(dateline.isEnabled());
        this.dateline = dateline;
        this.model = model;
        this.timeSpan = timeSpan;
        this.major = major;
        this.focus = focus;
        return this;
    }

    protected Color getMajorForeground(Dateline dateline, long date) {
        if (this.focus && this.focusedTimeVisible) {
            return this.focusForeground;
        }
        return dateline.getTimeline().getForeground();
    }

    protected Color getMajorBackground(Dateline dateline, long date) {
        if (this.focus && this.focusedTimeVisible) {
            return this.focusBackground;
        }
        return dateline.getTimeline().getBackground();
    }

    protected Color getMinorForeground(Dateline dateline, long date) {
        if (this.focus && this.focusedTimeVisible) {
            return this.focusForeground;
        }
        IDatelineModel datelineModel = dateline.getModel();
        ICalendarModel calendarModel = dateline.getTimeline().getGanttChart().getCalendarModel();
        Color color = this.getCalendarForeground(calendarModel, datelineModel, date);
        if (color != null) {
            return color;
        }
        return dateline.getTimeline().getForeground();
    }

    protected Color getMinorBackground(Dateline dateline, long date) {
        if (this.focus && this.focusedTimeVisible) {
            return this.focusBackground;
        }
        IDatelineModel datelineModel = dateline.getModel();
        ICalendarModel calendarModel = dateline.getTimeline().getGanttChart().getCalendarModel();
        Color col = this.getCalendarBackground(calendarModel, datelineModel, date);
        if (col != null) {
            return col;
        }
        return dateline.getTimeline().getBackground();
    }

    protected Color getCalendarForeground(ICalendarModel calendarModel, IDatelineModel datelineModel, long time) {
        Color col;
        Iterator iter;
        if (calendarModel != null && (iter = calendarModel.getCalendarEntries(datelineModel, new TimeSpan(time))) != null && iter.hasNext() && (col = this.getCalendarEntryForeground(iter.next().getClass())) != null) {
            return col;
        }
        return null;
    }

    protected Color getCalendarBackground(ICalendarModel calendarModel, IDatelineModel datelineModel, long time) {
        Color col;
        Iterator iter;
        if (calendarModel != null && (iter = calendarModel.getCalendarEntries(datelineModel, new TimeSpan(time))) != null && iter.hasNext() && (col = this.getCalendarEntryBackground(iter.next().getClass())) != null) {
            return col;
        }
        return null;
    }

    public void setCalendarEntryForeground(Class calendarEntryType, Color color) {
        if (calendarEntryType == null) {
            throw new IllegalArgumentException("calendar entry type can not be NULL");
        }
        this.foregroundMap.put(calendarEntryType, color);
    }

    public Color getCalendarEntryForeground(Class calendarEntryType) {
        if (calendarEntryType == null) {
            return null;
        }
        Color color = this.foregroundMap.get(calendarEntryType);
        if (color != null) {
            return color;
        }
        return this.getCalendarEntryForeground(calendarEntryType.getSuperclass());
    }

    public void setCalendarEntryBackground(Class calendarEntryType, Color color) {
        if (calendarEntryType == null) {
            throw new IllegalArgumentException("calendar entry type can not be NULL");
        }
        this.backgroundMap.put(calendarEntryType, color);
    }

    public Color getCalendarEntryBackground(Class calendarEntryType) {
        if (calendarEntryType == null) {
            return null;
        }
        Color color = this.backgroundMap.get(calendarEntryType);
        if (color != null) {
            return color;
        }
        return this.getCalendarEntryBackground(calendarEntryType.getSuperclass());
    }

    public void setFocusBackground(Color color) {
        this.focusBackground = color;
    }

    public Color getFocusBackground() {
        return this.focusBackground;
    }

    public void setFocusForeground(Color color) {
        this.focusForeground = color;
    }

    public Color getFocusForeground() {
        return this.focusForeground;
    }

    public Dateline getDateline() {
        return this.dateline;
    }

    @Override
    public boolean hasFocus() {
        return this.focus;
    }

    public boolean isMajor() {
        return this.major;
    }

    public T getModel() {
        return this.model;
    }

    public ITimeSpan getTimeSpan() {
        return this.timeSpan;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(int x2, int y2, int width, int height) {
    }

    @Override
    public void repaint(long tm) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

