/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.CapacityLine;
import com.dlsc.flexgantt.model.gantt.IResourceNode;
import com.dlsc.flexgantt.swing.layer.system.DefaultRowRenderer;
import com.dlsc.flexgantt.swing.layer.system.RowLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;

public class DefaultResourceRowRenderer
extends DefaultRowRenderer {
    private IResourceNode resourceNode;
    private Color majorCapacityLineColor = Color.GRAY;
    private Color minorCapacityLineColor = Color.LIGHT_GRAY;
    private boolean paintMajorCapacityLines = true;
    private boolean paintMinorCapacityLines = true;

    public DefaultResourceRowRenderer() {
        this.setOpaque(false);
        this.setFocusVisible(true);
    }

    public Color getMajorCapacityLineColor() {
        return this.majorCapacityLineColor;
    }

    public void setMajorCapacityLineColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("major capacity line color can not be NULL");
        }
        this.majorCapacityLineColor = color;
    }

    public Color getMinorCapacityLineColor() {
        return this.minorCapacityLineColor;
    }

    public void setMinorCapacityLineColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("minor capacity line color can not be NULL");
        }
        this.minorCapacityLineColor = color;
    }

    @Override
    public Component getRowRendererComponent(RowLayer layer, Object node, boolean selected, int row, ITimeSpan span, boolean hasFocus) {
        super.getRowRendererComponent(layer, node, selected, row, span, hasFocus);
        this.resourceNode = (IResourceNode)node;
        this.setOpaque(this.hasFocus() || selected && this.isShowingSelection());
        return this;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.isPaintMinorCapacityLines()) {
            g2.setColor(this.minorCapacityLineColor);
            this.paintLines(g2, false);
        }
        if (this.isPaintMajorCapacityLines()) {
            g2.setColor(this.majorCapacityLineColor);
            this.paintLines(g2, true);
        }
    }

    protected void paintLines(Graphics g2, boolean major) {
        Rectangle bounds = g2.getClipBounds();
        int height = this.getHeight() - 1;
        List<CapacityLine> capLines = this.resourceNode.getCapacityLines(height, major);
        int xx = bounds.x;
        for (CapacityLine line : capLines) {
            int y2 = this.resourceNode.getCapacityLocation(height, line.getCapacity());
            if (major) {
                g2.setColor(this.majorCapacityLineColor);
            } else {
                g2.setColor(this.minorCapacityLineColor);
            }
            g2.drawLine(xx, y2, bounds.x + bounds.width, y2);
        }
    }

    protected IResourceNode getResourceNode() {
        return this.resourceNode;
    }

    public boolean isPaintMajorCapacityLines() {
        return this.paintMajorCapacityLines;
    }

    public void setPaintMajorCapacityLines(boolean paintMajorCapacityLines) {
        this.paintMajorCapacityLines = paintMajorCapacityLines;
    }

    public boolean isPaintMinorCapacityLines() {
        return this.paintMinorCapacityLines;
    }

    public void setPaintMinorCapacityLines(boolean paintMinorCapacityLines) {
        this.paintMinorCapacityLines = paintMinorCapacityLines;
    }
}

