/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer.system;

import com.dlsc.flexgantt.model.gantt.IActivityObject;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.IEditActivityObjectPolicy;
import com.dlsc.flexgantt.policy.layer.IEditTimelineObjectPolicy;
import com.dlsc.flexgantt.swing.ObjectBounds;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.system.DefaultEditModeController;
import com.dlsc.flexgantt.swing.layer.system.DragLayer;
import com.dlsc.flexgantt.swing.layer.system.IEditModeController;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class ActivityObjectEditModeController
extends DefaultEditModeController {
    @Override
    public IEditModeController.EditMode getEditMode(DragLayer layer, ObjectBounds bounds, MouseEvent evt) {
        Object timelineObject = bounds.getObject();
        if (timelineObject instanceof IActivityObject) {
            LayerContainer layerContainer = layer.getLayerContainer();
            IPolicyProvider policyProvider = layerContainer.getPolicyProvider();
            IEditActivityObjectPolicy ap = policyProvider.getPolicy(IEditActivityObjectPolicy.class);
            IGanttChartModel model = bounds.getModel();
            if (ap.isPercentageChangeable(bounds.getPath(), model) && this.isChangePercentageLocation(bounds, evt)) {
                return IEditModeController.EditMode.CHANGE_PERCENTAGE_COMPLETE;
            }
        }
        return super.getEditMode(layer, bounds, evt);
    }

    @Override
    protected boolean isChangeStartTimeLocation(ObjectBounds bounds, MouseEvent evt, IEditTimelineObjectPolicy editPolicy) {
        return false;
    }

    protected boolean isChangePercentageLocation(ObjectBounds bounds, MouseEvent evt) {
        Object obj;
        if (!this.isUsingDragOverrideModifiers(evt) && (obj = bounds.getObject()) instanceof IActivityObject) {
            IActivityObject ao = (IActivityObject)obj;
            double complete = ao.getPercentageComplete();
            int completeX = (int)(complete / 100.0 * bounds.getWidth());
            Point p2 = evt.getPoint();
            return Math.abs(completeX - p2.x + bounds.x) < 10;
        }
        return false;
    }
}

