/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing.layer;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.dateline.DatelineModelEvent;
import com.dlsc.flexgantt.model.dateline.IDatelineModel;
import com.dlsc.flexgantt.model.dateline.IDatelineModelListener;
import com.dlsc.flexgantt.model.gantt.GanttChartModelEvent;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartModelListener;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.layer.ILinePolicy;
import com.dlsc.flexgantt.policy.layer.IOverviewPolicy;
import com.dlsc.flexgantt.policy.treetable.IRowPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.layer.ILayerContainerListener;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.layer.LayerContainerEvent;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import com.dlsc.flexgantt.swing.timeline.Dateline;
import com.dlsc.flexgantt.swing.treetable.TreeTableNode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;

public class OverviewPalette
extends JPanel
implements MouseListener,
MouseMotionListener,
PropertyChangeListener,
IDatelineModelListener {
    private LayerContainer lc;
    private Color visibleRectangleColor = Color.RED;
    private Rectangle area;
    private Rectangle box;
    private JViewport viewport;
    private AbstractGanttChart ganttChart;
    private BufferedImage buffer;

    public OverviewPalette(LayerContainer lc2) {
        if (lc2 == null) {
            throw new IllegalArgumentException("layer container can not be NULL");
        }
        this.lc = lc2;
        this.setBackground(Color.WHITE);
        this.setForeground(Color.GRAY);
        this.setPreferredSize(new Dimension(200, 200));
        this.setOpaque(true);
        Container con = lc2.getParent();
        do {
            if (!(con instanceof JViewport)) continue;
            this.viewport = (JViewport)con;
            this.viewport.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    OverviewPalette.this.repaint();
                }
            });
            break;
        } while ((con = con.getParent()) != null);
        lc2.addLayerContainerListener(new ILayerContainerListener(){

            @Override
            public void layerContainerChanged(LayerContainerEvent evt) {
                OverviewPalette.this.buffer = null;
                OverviewPalette.this.repaint();
            }
        });
        lc2.getModel().addGanttChartModelListener(new IGanttChartModelListener(){

            @Override
            public void ganttChartChanged(GanttChartModelEvent evt) {
                OverviewPalette.this.buffer = null;
                OverviewPalette.this.repaint();
            }
        });
        lc2.getTreeTable().addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent evt) {
                OverviewPalette.this.buffer = null;
                OverviewPalette.this.repaint();
            }

            @Override
            public void treeExpanded(TreeExpansionEvent evt) {
                OverviewPalette.this.buffer = null;
                OverviewPalette.this.repaint();
            }
        });
        this.ganttChart = lc2.getGanttChart();
        this.ganttChart.getDateline().addPropertyChangeListener(this);
        this.ganttChart.getDatelineModel().addDatelineModelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Insets insets = this.getInsets();
        this.area = new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        double sf = (double)(this.area.width - insets.left - insets.right) / (double)this.lc.getWidth();
        int totalHeight = this.lc.getTreeTable().getHeight();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.buffer == null || this.buffer.getWidth() != width || this.buffer.getHeight() != height) {
            ILayer[] layers;
            this.buffer = new BufferedImage(width, height, 2);
            Graphics2D g2d = (Graphics2D)this.buffer.getGraphics();
            super.paintComponent(g2d);
            IPolicyProvider pp = this.lc.getPolicyProvider();
            IOverviewPolicy policy = pp.getPolicy(IOverviewPolicy.class);
            ILinePolicy linePolicy = pp.getPolicy(ILinePolicy.class);
            IRowPolicy rowPolicy = this.lc.getTreeTable().getPolicyProvider().getPolicy(IRowPolicy.class);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(this.getBackground());
            g2d.setComposite(AlphaComposite.getInstance(3, 0.8f));
            IGanttChartModel model = this.lc.getModel();
            IDatelineModel datelineModel = this.lc.getGanttChart().getDateline().getModel();
            ITimeSpan span = datelineModel.getTimeSpan();
            List<TreeTableNode> nodes = this.lc.getTreeTable().getTreeTableNodes();
            for (ILayer layer : layers = this.lc.getLayers()) {
                TimelineObjectLayer layerUI;
                if (layer.isCustomLayer() || !layer.isFeatureEnabled(ILayer.Feature.OVERVIEW) || !(layerUI = this.lc.getTimelineObjectLayer(layer)).isVisible()) continue;
                for (TreeTableNode node : nodes) {
                    Object modelNode = node.getModelNode();
                    Iterator iter = model.getTimelineObjectsIterator(modelNode, layer, span);
                    while (iter.hasNext()) {
                        Object timelineObject = iter.next();
                        ITimeSpan objSpan = model.getTimeSpan(timelineObject);
                        int xx1 = (int)((double)this.lc.getDateline().getTimeLocation(objSpan.getStartTime()) * sf);
                        int xx2 = (int)((double)this.lc.getDateline().getTimeLocation(objSpan.getEndTime()) * sf);
                        g2d.setColor(this.getForeground());
                        Object status = policy.getOverviewStatus(modelNode, timelineObject, model);
                        int originalY = node.getY();
                        int lineCount = linePolicy.getLineCount(modelNode, model);
                        int lineIndex = linePolicy.getLineIndex(modelNode, model, timelineObject);
                        if (lineCount > 0 && lineIndex != -1) {
                            int rowHeight = rowPolicy.getRowHeight(modelNode, model);
                            originalY += linePolicy.getLineLocation(modelNode, model, lineIndex, rowHeight);
                        }
                        int y2 = this.convertGanttChartYToOverviewY(originalY, totalHeight);
                        if (status != null) {
                            Icon icon;
                            Color c2 = this.lc.getTimelineObjectStatusColor(status);
                            if (c2 != null) {
                                g2d.setColor(c2);
                            }
                            if ((icon = this.lc.getTimelineObjectStatusIcon(status)) != null) {
                                icon.paintIcon(this, g2d, this.area.x + xx1, y2);
                            }
                        }
                        g2d.drawLine(this.area.x + xx1, y2, this.area.x + xx2, y2);
                    }
                }
            }
        }
        g2.drawImage(this.buffer, 0, 0, this);
        this.paintVisibleRectangle(g2, sf, totalHeight);
    }

    private void paintVisibleRectangle(Graphics g2, double sf, int totalHeight) {
        Graphics2D g2d = (Graphics2D)g2;
        Dateline dateline = this.lc.getDateline();
        ITimeSpan visibleSpan = dateline.getVisibleTimeSpan();
        int xx1 = (int)((double)dateline.getTimeLocation(visibleSpan.getStartTime()) * sf) + this.area.x;
        int xx2 = (int)((double)dateline.getTimeLocation(visibleSpan.getEndTime()) * sf) + this.area.x;
        Rectangle visibleRect = this.lc.getTreeTable().getVisibleRect();
        int yy1 = this.convertGanttChartYToOverviewY(visibleRect.y, totalHeight);
        int yy2 = this.convertGanttChartYToOverviewY(visibleRect.y + visibleRect.height, totalHeight);
        g2d.setColor(this.visibleRectangleColor);
        Composite comp = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
        this.box = new Rectangle(xx1, yy1, xx2 - xx1 + 1, yy2 - yy1);
        g2d.fillRect(this.box.x, this.box.y, this.box.width, this.box.height);
        g2d.setComposite(comp);
        g2d.drawRect(this.box.x, this.box.y, this.box.width, this.box.height);
    }

    private int convertGanttChartYToOverviewY(int y2, int totalHeight) {
        Insets insets = this.getInsets();
        double p2 = (double)y2 / (double)totalHeight;
        return (int)(p2 * this.area.getHeight() + (double)insets.top);
    }

    private Point convertLocation(Point p2) {
        return this.convertLocation(p2.x, p2.y);
    }

    private Point convertLocation(int x2, int y2) {
        double p1 = (double)this.lc.getHeight() / this.area.getHeight();
        int yy = (int)((double)y2 * p1);
        double p2 = (double)this.lc.getWidth() / this.area.getWidth();
        int xx = (int)((double)x2 * p2);
        return new Point(xx, yy);
    }

    public LayerContainer getLayerContainer() {
        return this.lc;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        Point p2 = this.convertLocation(e2.getPoint());
        Rectangle rect = this.lc.getVisibleRect();
        rect.x = p2.x;
        rect.y = p2.y;
        this.lc.scrollRectToVisible(rect);
        this.requestFocusInWindow();
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        Point p2 = e2.getPoint();
        p2.translate(-this.box.width / 2, -this.box.height / 2);
        p2.x = Math.min(this.getWidth() - this.box.width, Math.max(0, p2.x));
        p2.y = Math.min(this.getHeight() - this.box.height, Math.max(0, p2.y));
        p2 = this.convertLocation(p2);
        p2.x = Math.max(0, Math.min(p2.x, this.lc.getWidth() - this.lc.getVisibleRect().width));
        p2.y = Math.max(0, Math.min(p2.y, this.lc.getHeight() - this.lc.getVisibleRect().height));
        this.viewport.setViewPosition(p2);
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        if (this.box.contains(e2.getPoint())) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.lc.getDateline()) && evt.getPropertyName().equals("datelineModel")) {
            IDatelineModel oldModel = (IDatelineModel)evt.getOldValue();
            IDatelineModel newModel = (IDatelineModel)evt.getNewValue();
            if (oldModel != null) {
                oldModel.removeDatelineModelListener(this);
            }
            if (newModel != null) {
                newModel.addDatelineModelListener(this);
            }
        }
    }

    @Override
    public void datelineModelWillChange(DatelineModelEvent evt) {
    }

    @Override
    public void datelineModelChanged(DatelineModelEvent evt) {
        if (evt.getSource().equals(this.ganttChart.getDatelineModel())) {
            this.buffer = null;
            this.repaint();
        }
    }
}

