/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.MessageTypeId;
import com.dlsc.flexgantt.swing.NavigationControlPanel;
import com.dlsc.flexgantt.swing.NavigationControlType;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import com.dlsc.flexgantt.swing.selector.ISelectorFactory;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.swing.timeline.Timeline;
import com.dlsc.flexgantt.swing.util.CustomizableLineBorder;
import com.dlsc.flexgantt.swing.util.RollOverLabel;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class NavigationControl
extends RollOverLabel {
    private final NavigationControlType type;
    private final NavigationControlPanel navigationControlPanel;
    private final AbstractGanttChart ganttChart;

    public NavigationControl(NavigationControlPanel controlPanel, NavigationControlType type) {
        super("");
        this.navigationControlPanel = controlPanel;
        this.ganttChart = controlPanel.getGanttChart();
        this.type = type;
        this.setPreferredSize(new Dimension(15, 15));
        this.setBorder(new CustomizableLineBorder());
        switch (type) {
            case BOOKMARKS: {
                this.setIcon(IconRegistry.getIcon(IconId.BOOKMARK_SMALL));
                this.setName("Bookmarks");
                this.setToolTipText(Messages.getString("NavigationControl.TOOLTIP_SHOW_BOOKMARKS"));
                break;
            }
            case GRANULARITY: {
                this.setIcon(IconRegistry.getIcon(IconId.GRANULARITY));
                this.setName("Granularity");
                this.setToolTipText(Messages.getString("NavigationControl.SELECT_GRANULARITY"));
                break;
            }
            case TIME_NOW: {
                this.setIcon(IconRegistry.getIcon(IconId.TIME_NOW_SMALL));
                this.setName("TimeNowControl");
                this.setToolTipText(Messages.getString("NavigationControl.TOOLTIP_TIME_NOW"));
                break;
            }
            case ZOOM_IN: {
                this.setIcon(IconRegistry.getIcon(IconId.ZOOM_IN_SMALL));
                this.setName("ZoomInControl");
                this.setToolTipText(Messages.getString("NavigationControl.TOOLTIP_ZOOM_IN"));
                break;
            }
            case ZOOM_OUT: {
                this.setIcon(IconRegistry.getIcon(IconId.ZOOM_OUT_SMALL));
                this.setName("ZoomOutControl");
                this.setToolTipText(Messages.getString("NavigationControl.TOOLTIP_ZOOM_OUT"));
                break;
            }
            case TIME_SPAN: {
                this.setIcon(IconRegistry.getIcon(IconId.TIME_SPAN_SMALL));
                this.setName("TimeSpanControl");
                this.setToolTipText(Messages.getString("NavigationControl.TOOLTIP_EDIT_HORIZON"));
                break;
            }
            case ALL_OBJECTS: {
                this.setIcon(IconRegistry.getIcon(IconId.ALL_OBJECTS_SMALL));
                this.setName("AllObjectsControl");
                this.setToolTipText(Messages.getString("NavigationControl.TOOLTIP_ALL_OBJECTS"));
                break;
            }
            case EARLIEST_OBJECT: {
                this.setIcon(IconRegistry.getIcon(IconId.EARLIEST_OBJECTS_SMALL));
                this.setName("EarliestObjectsControl");
                this.setToolTipText(Messages.getString("NavigationControl.TOOLTIP_EARLIEST_OBJECTS"));
                break;
            }
            case LATEST_OBJECT: {
                this.setIcon(IconRegistry.getIcon(IconId.LATEST_OBJECTS_SMALL));
                this.setName("LatestObjectsControl");
                this.setToolTipText(Messages.getString("NavigationControl.TOOLTIP_LATEST_OBJECTS"));
                break;
            }
            case GOTO: {
                this.setIcon(IconRegistry.getIcon(IconId.GOTO));
                this.setName("GotoControl");
                this.setToolTipText(Messages.getString("NavigationControl.TOOLTIP_GOTO"));
            }
        }
        this.setHorizontalAlignment(0);
        this.addMouseListener(new MouseAdapter(){
            private Selector gotoSelector;
            private Selector horizonSelector;
            private Selector bookmarkSelector;
            private Selector granularitySelector;

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (NavigationControl.this.isEnabled()) {
                    Timeline tl = NavigationControl.this.ganttChart.getTimeline();
                    LayerContainer lc2 = NavigationControl.this.navigationControlPanel.getLayerContainer();
                    ISelectorFactory sf = NavigationControl.this.ganttChart.getSelectorFactory();
                    String errorMessage = null;
                    switch (NavigationControl.this.type) {
                        case BOOKMARKS: {
                            if (this.bookmarkSelector == null) {
                                this.bookmarkSelector = sf.createSelector(lc2, (JComponent)NavigationControl.this, ISelectorFactory.SelectorID.BOOKMARKS);
                            }
                            this.bookmarkSelector.setVisible(!this.bookmarkSelector.isVisible());
                            break;
                        }
                        case GRANULARITY: {
                            if (this.granularitySelector == null) {
                                this.granularitySelector = sf.createSelector(NavigationControl.this.ganttChart, (JComponent)NavigationControl.this, ISelectorFactory.SelectorID.GRANULARITY);
                            }
                            this.granularitySelector.setVisible(!this.granularitySelector.isVisible());
                            break;
                        }
                        case ZOOM_IN: {
                            tl.getDateline().zoomIn();
                            break;
                        }
                        case ZOOM_OUT: {
                            tl.getDateline().zoomOut();
                            break;
                        }
                        case GOTO: {
                            if (this.gotoSelector == null) {
                                this.gotoSelector = sf.createSelector(NavigationControl.this.ganttChart, (JComponent)NavigationControl.this, ISelectorFactory.SelectorID.GOTO);
                            }
                            this.gotoSelector.setVisible(!this.gotoSelector.isVisible());
                            break;
                        }
                        case TIME_NOW: {
                            NavigationControl.this.ganttChart.showTimeNow(NavigationControl.this.navigationControlPanel.isCenterTimeNow());
                            break;
                        }
                        case TIME_SPAN: {
                            if (this.horizonSelector == null) {
                                this.horizonSelector = sf.createSelector(NavigationControl.this.ganttChart, (JComponent)NavigationControl.this, ISelectorFactory.SelectorID.HORIZON);
                            }
                            this.horizonSelector.setVisible(!this.horizonSelector.isVisible());
                            break;
                        }
                        case EARLIEST_OBJECT: {
                            if (!lc2.getTimeSpanUsed().isUndefined()) {
                                lc2.showEarliestObjects();
                                break;
                            }
                            errorMessage = Messages.getString("NavigationControl.NO_OBJECTS_FOUND");
                            break;
                        }
                        case LATEST_OBJECT: {
                            if (!lc2.getTimeSpanUsed().isUndefined()) {
                                lc2.showLatestObjects();
                                break;
                            }
                            errorMessage = Messages.getString("NavigationControl.NO_OBJECTS_FOUND");
                            break;
                        }
                        case ALL_OBJECTS: {
                            if (!lc2.getTimeSpanUsed().isUndefined()) {
                                lc2.showAllObjects();
                                break;
                            }
                            errorMessage = Messages.getString("NavigationControl.NO_OBJECTS_FOUND");
                        }
                    }
                    if (errorMessage != null) {
                        NavigationControl.this.ganttChart.showMessage(errorMessage, MessageTypeId.ERROR);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
            }

            @Override
            public void mouseExited(MouseEvent e2) {
            }
        });
    }

    public NavigationControlPanel getNavigationControlPanel() {
        return this.navigationControlPanel;
    }

    public AbstractGanttChart getGanttChart() {
        return this.ganttChart;
    }
}

