/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.IMessage;
import com.dlsc.flexgantt.swing.IMessageListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class MessageTableModel
extends AbstractTableModel
implements IMessageListener {
    private AbstractGanttChart gc;
    private List<IMessage> model = new ArrayList<IMessage>();

    public MessageTableModel(AbstractGanttChart gc2) {
        this.gc = gc2;
        this.model.addAll(gc2.getMessages());
        this.gc.addMessageListener(this);
    }

    @Override
    public int getRowCount() {
        return this.model.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        IMessage msg = this.model.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                switch (msg.getMessageTypeId()) {
                    case INFORMATION: {
                        return IconRegistry.getIcon(IconId.INFORMATION);
                    }
                    case WARNING: {
                        return IconRegistry.getIcon(IconId.WARNING);
                    }
                    case ERROR: {
                        return IconRegistry.getIcon(IconId.ERROR);
                    }
                }
                return IconRegistry.getIcon(IconId.BLANK);
            }
            case 1: {
                return msg.getMessageText();
            }
            case 2: {
                return msg.getMessageTime();
            }
        }
        return null;
    }

    public IMessage getMessageInRow(int row) {
        if (row < this.model.size()) {
            return this.model.get(row);
        }
        return null;
    }

    @Override
    public void messageAdded(IMessage msg) {
        this.model.add(msg);
        int index = this.model.indexOf(msg);
        this.fireTableRowsInserted(index, index);
    }

    @Override
    public void messageRemoved(IMessage msg) {
        int index = this.model.indexOf(msg);
        this.model.remove(msg);
        this.fireTableRowsDeleted(index, index);
    }

    @Override
    public void messagesCleared() {
        int index = this.model.size();
        this.model.clear();
        this.fireTableRowsDeleted(0, index);
    }
}

