/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.swing;

import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.util.FlexGanttLicenseManager;
import com.dlsc.flexgantt.util.Messages;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class LicenseDialog
extends JDialog {
    private static LicenseDialog instance;
    private String customer;
    private String version;
    private String issuer;
    private String license;

    private LicenseDialog(Frame frame) {
        super(frame, Messages.getString("LicenseDialog.TITLE"));
        this.init();
    }

    private LicenseDialog(Dialog dialog) {
        super(dialog, Messages.getString("LicenseDialog.TITLE"));
        this.init();
    }

    private void init() {
        this.setResizable(false);
        URL url = this.getClass().getResource("License.png");
        this.add("Center", new JLabel(new ImageIcon(url)));
        this.setFont(new Font("helvetica", 0, 14));
        this.customer = FlexGanttLicenseManager.getLicensee();
        this.issuer = FlexGanttLicenseManager.getVendor();
        this.version = FlexGanttLicenseManager.getVersion();
        if (FlexGanttLicenseManager.isTrialLicense()) {
            this.license = Messages.getString("LicenseDialog.TRIAL");
        }
        if (FlexGanttLicenseManager.isDevelopmentLicense()) {
            this.license = Messages.getString("LicenseDialog.DEVELOPMENT");
        }
        if (FlexGanttLicenseManager.isRuntimeLicense()) {
            this.license = Messages.getString("LicenseDialog.RUNTIME");
        }
        this.pack();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                if (e2.getKeyCode() == 27) {
                    LicenseDialog.this.setVisible(false);
                }
            }
        });
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        g2.setColor(Color.WHITE);
        g2.drawString(Messages.getString("LicenseDialog.CUSTOMER") + this.customer, 25, 70);
        g2.drawString(Messages.getString("LicenseDialog.LICENSE_ISSUER") + this.issuer, 25, 88);
        g2.drawString(Messages.getString("LicenseDialog.LICENSE_TYPE") + this.license, 25, 106);
        g2.drawString(Messages.getString("LicenseDialog.PRODUCT_VERSION") + this.version, 25, 124);
    }

    public static void showDialog(AbstractGanttChart gc2) {
        if (instance == null) {
            Window window = SwingUtilities.getWindowAncestor(gc2);
            if (window instanceof Frame) {
                instance = new LicenseDialog((Frame)window);
            } else if (window instanceof Dialog) {
                instance = new LicenseDialog((Dialog)window);
            }
        }
        instance.setLocationRelativeTo(gc2);
        instance.setVisible(true);
    }
}

