/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.policy.treetable;

import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.treetable.DefaultNodeDragAndDropCommand;
import com.dlsc.flexgantt.model.treetable.DefaultMutableTreeTableNode;
import com.dlsc.flexgantt.model.treetable.DefaultTreeTableModel;
import com.dlsc.flexgantt.model.treetable.ITreeTableModel;
import com.dlsc.flexgantt.model.treetable.ITreeTableNode;
import com.dlsc.flexgantt.policy.AbstractPolicy;
import com.dlsc.flexgantt.policy.treetable.INodeDragAndDropPolicy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultNodeDragAndDropPolicy
extends AbstractPolicy
implements INodeDragAndDropPolicy {
    private static final Logger LOGGER = Logger.getLogger(DefaultNodeDragAndDropPolicy.class.getName());

    @Override
    public int getDragActions(Object node, ITreeTableModel model) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("node = " + node + " key = " + model.getKey(node));
            LOGGER.fine("model = " + model);
        }
        int actions = ((ITreeTableNode)node).getDragActions();
        if (LOGGER.isLoggable(Level.FINE)) {
            switch (actions) {
                case 1: {
                    LOGGER.fine("drag action = ACTION_COPY");
                    break;
                }
                case 2: {
                    LOGGER.fine("drag action = ACTION_MOVE");
                    break;
                }
                case 3: {
                    LOGGER.fine("drag action = ACTION_COPY_OR_MOVE");
                    break;
                }
                case 0x40000000: {
                    LOGGER.fine("drag action = ACTION_LINK");
                    break;
                }
                case 0: {
                    LOGGER.fine("drop action = ACTION_NONE");
                    break;
                }
                default: {
                    LOGGER.log(Level.SEVERE, "completely unknown action (only use values defined in DnDConstants)");
                }
            }
        }
        return actions;
    }

    @Override
    public int getDropActions(Object draggedNode, Object draggedNodeParent, ITreeTableModel draggedNodeModel, Object newParentNode, ITreeTableModel newModel) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("dropped node = " + draggedNode + " key = " + draggedNodeModel.getKey(draggedNode));
            if (draggedNodeParent != null) {
                LOGGER.fine("dragged node parent = " + draggedNodeParent + " key = " + draggedNodeModel.getKey(draggedNodeParent));
            }
            LOGGER.fine("dragged node model = " + draggedNodeModel);
            LOGGER.fine("new parent node = " + newParentNode + " key = " + newModel.getKey(newParentNode));
            LOGGER.fine("new model = " + newModel);
        }
        int actions = ((ITreeTableNode)newParentNode).getDropActions((ITreeTableNode)draggedNode);
        if (LOGGER.isLoggable(Level.FINE)) {
            switch (actions) {
                case 1: {
                    LOGGER.fine("drop action = ACTION_COPY");
                    break;
                }
                case 2: {
                    LOGGER.fine("drop action = ACTION_MOVE");
                    break;
                }
                case 3: {
                    LOGGER.fine("drop action = ACTION_COPY_OR_MOVE");
                    break;
                }
                case 0x40000000: {
                    LOGGER.fine("drop action = ACTION_LINK");
                    break;
                }
                case 0: {
                    LOGGER.fine("drop action = ACTION_NONE");
                    break;
                }
                default: {
                    LOGGER.log(Level.SEVERE, "completely unknown action (only use values defined in DnDConstants)");
                }
            }
        }
        return actions;
    }

    @Override
    public ICommand getDragAndDropCommand(Object droppedNode, Object oldParent, ITreeTableModel oldModel, int oldChildIndex, Object newParent, ITreeTableModel newModel, int newChildIndex, int dropAction) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("dropped node = " + droppedNode + " key = " + oldModel.getKey(droppedNode));
            LOGGER.fine("current parent = " + oldParent + " key = " + oldModel.getKey(oldParent));
            LOGGER.fine("current model = " + oldModel);
            LOGGER.fine("current child index = " + oldChildIndex);
            LOGGER.fine("new parent = " + newParent + " key = " + newModel.getKey(newParent));
            LOGGER.fine("new model = " + newModel);
            LOGGER.fine("new child index = " + newChildIndex);
            switch (dropAction) {
                case 1: {
                    LOGGER.fine("drop action = ACTION_COPY");
                    break;
                }
                case 2: {
                    LOGGER.fine("drop action = ACTION_MOVE");
                    break;
                }
                case 3: {
                    LOGGER.fine("drop action = ACTION_COPY_OR_MOVE");
                    break;
                }
                case 0x40000000: {
                    LOGGER.fine("drop action = ACTION_LINK");
                    break;
                }
                case 0: {
                    LOGGER.fine("drop action = ACTION_NONE");
                    break;
                }
                default: {
                    LOGGER.log(Level.SEVERE, "completely unknown action (only use values defined in DnDConstants)");
                }
            }
        }
        return new DefaultNodeDragAndDropCommand((DefaultMutableTreeTableNode)droppedNode, (DefaultMutableTreeTableNode)oldParent, (DefaultTreeTableModel)oldModel, oldChildIndex, (DefaultMutableTreeTableNode)newParent, (DefaultTreeTableModel)newModel, newChildIndex, dropAction);
    }
}

