/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.policy;

import com.dlsc.flexgantt.policy.IPolicy;
import com.dlsc.flexgantt.policy.IPolicyProvider;
import com.dlsc.flexgantt.policy.IPolicyProviderListener;
import com.dlsc.flexgantt.policy.PolicyProviderEvent;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class PolicyProvider
extends HashMap<Class<? extends IPolicy>, IPolicy>
implements IPolicyProvider {
    private static final Logger LOGGER = Logger.getLogger(PolicyProvider.class.getName());
    private EventListenerList listenerList = new EventListenerList();

    @Override
    public <T extends IPolicy> void setPolicy(Class<T> policyType, T policy) {
        LOGGER.fine("setting policy, type = " + policyType + ", policy = " + policy);
        if (policyType == null) {
            throw new IllegalArgumentException("policy type can not be NULL");
        }
        if (policy == null) {
            throw new IllegalArgumentException("policy can not be NULL");
        }
        if (!policyType.isInterface()) {
            throw new IllegalArgumentException("policy type parameter must be an interface but was an implementation");
        }
        if (!policyType.isAssignableFrom(policy.getClass())) {
            throw new IllegalArgumentException("policy does not implement the required policy interface " + policyType.getClass().getName());
        }
        this.put(policyType, policy);
        PolicyProviderEvent evt = new PolicyProviderEvent(this, PolicyProviderEvent.ID.POLICY_IMPLEMENTATION_CHANGED, policyType, policy);
        this.firePolicyProviderEvent(evt);
    }

    @Override
    public <T extends IPolicy> T getPolicy(Class<T> policyType) {
        Class<T> superType;
        if (policyType == null) {
            throw new IllegalArgumentException("policy type can not be NULL");
        }
        IPolicy policy = (IPolicy)this.get(policyType);
        if (policy != null) {
            return (T)policy;
        }
        if (!policyType.equals(Object.class) && (superType = policyType.getSuperclass()) != null) {
            return this.getPolicy(superType);
        }
        throw new IllegalArgumentException("no policy of type " + policyType.getClass().getName() + " found");
    }

    @Override
    public void addPolicyProviderListener(IPolicyProviderListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException("listener can not be NULL");
        }
        this.listenerList.add(IPolicyProviderListener.class, l2);
    }

    @Override
    public void removePolicyProviderListener(IPolicyProviderListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException("listener can not be NULL");
        }
        this.listenerList.remove(IPolicyProviderListener.class, l2);
    }

    protected void firePolicyProviderEvent(PolicyProviderEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != IPolicyProviderListener.class) continue;
            ((IPolicyProviderListener)listeners[i2 + 1]).policyProviderChanged(evt);
        }
    }
}

