/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.scheduling;

import com.dlsc.flexgantt.command.CommandStackEvent;
import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.ICommandStack;
import com.dlsc.flexgantt.command.ICommandStackListener;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.model.gantt.IGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IRelationship;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.model.scheduling.AbstractResolution;
import com.dlsc.flexgantt.model.scheduling.ConstraintViolationMessage;
import com.dlsc.flexgantt.model.scheduling.IConstraint;
import com.dlsc.flexgantt.model.scheduling.IModelValidator;
import com.dlsc.flexgantt.model.scheduling.Violation;
import com.dlsc.flexgantt.policy.layer.IEditTimelineObjectPolicy;
import com.dlsc.flexgantt.swing.AbstractGanttChart;
import com.dlsc.flexgantt.swing.IMessage;
import com.dlsc.flexgantt.swing.layer.LayerContainer;
import java.util.Iterator;
import java.util.logging.Logger;

public class DefaultTimeGranularityFixBufferResolution
extends AbstractResolution<TimeGranularity> {
    private static final Logger LOGGER = Logger.getLogger(DefaultTimeGranularityFixBufferResolution.class.getName());
    private boolean waterfall;

    public DefaultTimeGranularityFixBufferResolution(boolean waterfall) {
        super(waterfall ? "Fix Recursively" : "Fix");
        this.waterfall = waterfall;
    }

    @Override
    public void resolve(LayerContainer lc2, IConstraint<?, TimeGranularity> constraint, Violation violation, IModelValidator validator) {
        TimelineObjectPath sourcePath = constraint.getSourcePath();
        Object sourceTLO = sourcePath.getTimelineObject();
        IGanttChartModel model = lc2.getModel();
        ITimeSpan sourceSpan = model.getTimeSpan(sourceTLO);
        this.resolve(lc2, constraint, violation, sourceSpan, validator);
    }

    private void resolve(final LayerContainer lc2, IConstraint<?, TimeGranularity> constraint, Violation violation, ITimeSpan sourceSpan, final IModelValidator validator) {
        LOGGER.fine("Resolving constraint violation. Violation = " + violation);
        TimelineObjectPath sourcePath = constraint.getSourcePath();
        TimelineObjectPath targetPath = constraint.getTargetPath();
        LOGGER.fine("source path = " + sourcePath);
        LOGGER.fine("target path = " + targetPath);
        IEditTimelineObjectPolicy ep = lc2.getPolicyProvider().getPolicy(IEditTimelineObjectPolicy.class);
        final IGanttChartModel model = lc2.getModel();
        if (ep.isStartTimeChangeable(targetPath, model)) {
            Object sourceTLO = sourcePath.getTimelineObject();
            final Object targetTLO = targetPath.getTimelineObject();
            LOGGER.fine("source TLO = " + sourceTLO);
            LOGGER.fine("target TLO = " + targetTLO);
            ITimeSpan targetSpan = model.getTimeSpan(targetTLO);
            double bufferDuration = constraint.getBufferDuration();
            TimeGranularity tg = constraint.getBufferGranularity();
            long newStartTime = 0L;
            long newEndTime = 0L;
            long buffer = 0L;
            switch (constraint.getBufferType()) {
                case EXACTLY: 
                case LESS_OR_EXACTLY: 
                case MORE_OR_EXACTLY: {
                    buffer = (long)((double)tg.getMilliseconds() * bufferDuration);
                    break;
                }
                case MORE_THAN: {
                    buffer = (long)((double)tg.getMilliseconds() * (bufferDuration + 1.0));
                    break;
                }
                case LESS_THAN: {
                    buffer = (long)((double)tg.getMilliseconds() * (bufferDuration - 1.0));
                }
            }
            LOGGER.fine("constraint type: " + (Object)((Object)constraint.getType()));
            switch (constraint.getType()) {
                case END_TO_START: {
                    newStartTime = sourceSpan.getEndTime() + buffer;
                    newEndTime = newStartTime + targetSpan.getDuration();
                    break;
                }
                case END_TO_END: {
                    newEndTime = sourceSpan.getEndTime() + buffer;
                    newStartTime = newEndTime - targetSpan.getDuration();
                    break;
                }
                case START_TO_START: {
                    newStartTime = sourceSpan.getStartTime() + buffer;
                    newEndTime = newStartTime + targetSpan.getDuration();
                    break;
                }
                case START_TO_END: {
                    newEndTime = sourceSpan.getStartTime() + buffer;
                    newStartTime = newEndTime - targetSpan.getDuration();
                }
            }
            TimeSpan newSpan = new TimeSpan(newStartTime, newEndTime);
            LOGGER.fine("new time span = " + newSpan);
            final ICommand cmd = ep.getChangeTimeSpanCommand(targetPath, model, newSpan, 2);
            LOGGER.fine("cmd = " + cmd);
            AbstractGanttChart gc2 = lc2.getGanttChart();
            LOGGER.fine("waterfall = " + this.waterfall);
            if (this.waterfall) {
                final ICommandStack commandStack = gc2.getCommandStack();
                ICommandStackListener listener = new ICommandStackListener(){

                    @Override
                    public void commandStackChanged(CommandStackEvent e2) {
                        if (e2.getCommand().equals(cmd) && e2.getId().equals((Object)CommandStackEvent.ID.COMMAND_EXECUTED)) {
                            Iterator<IRelationship<Object>> relationships = model.getRelationships(targetTLO);
                            while (relationships.hasNext()) {
                                IConstraint followUpConstraint;
                                IMessage message;
                                IRelationship<Object> rel = relationships.next();
                                if (!(rel instanceof IConstraint) || !rel.getSourcePath().getTimelineObject().equals(targetTLO) || !((message = validator.validate(model, followUpConstraint = (IConstraint)rel)) instanceof ConstraintViolationMessage)) continue;
                                ConstraintViolationMessage cvm = (ConstraintViolationMessage)message;
                                Violation followUpViolation = cvm.getViolation();
                                DefaultTimeGranularityFixBufferResolution.this.resolve(lc2, followUpConstraint, followUpViolation, validator);
                            }
                            commandStack.removeCommandStackListener(this);
                        }
                    }
                };
                commandStack.addCommandStackListener(listener);
            }
            gc2.commandExecute(cmd);
        }
    }
}

