/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.layer;

import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.command.layer.AbstractDragAndDropCommand;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ILayer;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import java.util.ArrayList;

public class DefaultDragAndDropCommand
extends AbstractDragAndDropCommand {
    private ITimelineObject timelineObject;
    private ITimeSpan oldTimeSpan;
    private ITimeSpan newTimeSpan;

    public DefaultDragAndDropCommand(IGanttChartNode owner, ILayer layer, ITimelineObject object, DefaultGanttChartModel model, IGanttChartNode newOwner, DefaultGanttChartModel newModel, long newStartTime, int dropAction) {
        super(owner, layer, model, newOwner, newModel, dropAction);
        if (object == null) {
            throw new IllegalArgumentException("timeline object can not be NULL");
        }
        this.timelineObject = object;
        this.oldTimeSpan = object.getTimeSpan();
        this.newTimeSpan = new TimeSpan(newStartTime, newStartTime + this.oldTimeSpan.getDuration());
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        ArrayList<ITimelineObject> list = new ArrayList<ITimelineObject>();
        list.add(this.timelineObject);
        DefaultGanttChartModel oldModel = this.getOldModel();
        IGanttChartNode oldOwner = this.getOldOwner();
        DefaultGanttChartModel newModel = this.getNewModel();
        IGanttChartNode newOwner = this.getNewOwner();
        ILayer layer = this.getLayer();
        oldModel.removeTimelineObjects(oldOwner, layer, list);
        this.timelineObject.setTimeSpan(this.newTimeSpan);
        newModel.addTimelineObjects(newOwner, layer, list);
        this.fixRelationships(this.timelineObject, oldOwner, newOwner, oldModel, newModel);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        ArrayList<ITimelineObject> list = new ArrayList<ITimelineObject>();
        list.add(this.timelineObject);
        DefaultGanttChartModel oldModel = this.getOldModel();
        IGanttChartNode oldOwner = this.getOldOwner();
        DefaultGanttChartModel newModel = this.getNewModel();
        IGanttChartNode newOwner = this.getNewOwner();
        ILayer layer = this.getLayer();
        newModel.removeTimelineObjects(newOwner, layer, list);
        oldModel.setTimeSpan(this.timelineObject, this.oldTimeSpan);
        oldModel.addTimelineObjects(oldOwner, layer, list);
        this.fixRelationships(this.timelineObject, newOwner, oldOwner, newModel, oldModel);
    }

    public ITimeSpan getNewTimeSpan() {
        return this.newTimeSpan;
    }

    public ITimeSpan getOldTimeSpan() {
        return this.oldTimeSpan;
    }

    public ITimelineObject getTimelineObject() {
        return this.timelineObject;
    }
}

