/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command;

import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.ICommand;
import com.dlsc.flexgantt.command.IProgressMonitor;
import java.util.logging.Logger;

public abstract class AbstractCommand
implements ICommand {
    private static final Logger LOGGER = Logger.getLogger(AbstractCommand.class.getName());
    private String name;

    protected AbstractCommand(String name) {
        if (name == null || name.trim().equals("")) {
            throw new IllegalArgumentException("command name can not be NULL or blank");
        }
        LOGGER.fine("creating command '" + name + "'");
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.trim().equals("")) {
            throw new IllegalArgumentException("name can not be empty");
        }
        this.name = name;
    }

    @Override
    public boolean isRedoable() {
        return true;
    }

    @Override
    public boolean isRelevant() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void redoCommand(IProgressMonitor monitor) throws CommandException {
        this.executeCommand(monitor);
    }
}

