/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing.renderer;

import com.dlsc.emirates.generated.flights.ROW;
import com.dlsc.emirates.model.FlightTimelineObject;
import com.dlsc.emirates.swing.hud.SettingsHUD;
import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.model.gantt.TimelineObjectPath;
import com.dlsc.flexgantt.swing.layer.timeline.ITimelineObjectRenderer;
import com.dlsc.flexgantt.swing.layer.timeline.TimelineObjectLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class FlightTimelineObjectRenderer
extends JComponent
implements ITimelineObjectRenderer {
    private FlightTimelineObject flight;
    private int barHeight = 14;
    private Insets insets = new Insets(0, 0, 0, 0);
    private boolean selected;
    private boolean focused;
    private boolean highlighted;
    private Color highlightColor = Color.LIGHT_GRAY;
    private Color focusColor = Color.LIGHT_GRAY;
    private Map<String, Color> aircraftBackgroundColorMap = new HashMap<String, Color>();
    private Map<String, Color> aircraftForegroundColorMap = new HashMap<String, Color>();
    private Icon followUpIcon = IconRegistry.getIcon(IconId.WARNING);
    private Icon invalidIcon = IconRegistry.getIcon(IconId.ERROR);
    private Icon starIcon = new ImageIcon(FlightTimelineObjectRenderer.class.getResource("star_yellow.png"));
    private Map<String, Paint> texturePaintMap;
    private BufferedImage eTextureImage;
    private BufferedImage nTextureImage;
    private BufferedImage yTextureImage;
    private BufferedImage jTextureImage;
    private BufferedImage zTextureImage;

    public FlightTimelineObjectRenderer() {
        this.setFont(new Font("Monospaced", 1, 10));
        this.eTextureImage = new BufferedImage(4, 4, 2);
        Graphics2D g2d = (Graphics2D)this.eTextureImage.getGraphics();
        g2d.setColor(Color.RED);
        g2d.drawLine(0, 0, 3, 3);
        this.nTextureImage = new BufferedImage(4, 4, 2);
        g2d = (Graphics2D)this.nTextureImage.getGraphics();
        g2d.setColor(Color.RED);
        g2d.drawLine(0, 0, 3, 3);
        g2d.drawLine(3, 0, 0, 3);
        this.yTextureImage = new BufferedImage(4, 4, 2);
        g2d = (Graphics2D)this.yTextureImage.getGraphics();
        g2d.setColor(Color.RED);
        g2d.drawLine(0, 0, 0, 0);
        g2d.drawLine(3, 1, 3, 1);
        g2d.drawLine(0, 2, 0, 2);
        g2d.drawLine(3, 3, 3, 3);
        this.jTextureImage = new BufferedImage(4, 4, 2);
        g2d = (Graphics2D)this.jTextureImage.getGraphics();
        g2d.setColor(Color.RED);
        g2d.drawLine(2, 0, 2, 3);
        this.zTextureImage = new BufferedImage(4, 4, 2);
        g2d = (Graphics2D)this.zTextureImage.getGraphics();
        g2d.setColor(Color.RED);
        g2d.drawLine(0, 2, 0, 2);
        this.texturePaintMap = this.createTexturePaintMap();
        this.aircraftBackgroundColorMap.put("772", Color.ORANGE);
        this.aircraftBackgroundColorMap.put("773", Color.GREEN);
        this.aircraftBackgroundColorMap.put("388", Color.BLUE);
        this.aircraftBackgroundColorMap.put("77W", Color.CYAN);
        this.aircraftBackgroundColorMap.put("332", Color.YELLOW);
        this.aircraftBackgroundColorMap.put("343", Color.MAGENTA);
        this.aircraftBackgroundColorMap.put("345", Color.PINK);
        this.aircraftBackgroundColorMap.put("77L", Color.RED);
        this.aircraftForegroundColorMap.put("772", Color.BLACK);
        this.aircraftForegroundColorMap.put("773", Color.BLACK);
        this.aircraftForegroundColorMap.put("388", Color.WHITE);
        this.aircraftForegroundColorMap.put("77W", Color.BLACK);
        this.aircraftForegroundColorMap.put("332", Color.BLACK);
        this.aircraftForegroundColorMap.put("343", Color.WHITE);
        this.aircraftForegroundColorMap.put("345", Color.BLACK);
        this.aircraftForegroundColorMap.put("77L", Color.WHITE);
    }

    @Override
    public Component getTimelineObjectRendererComponent(TimelineObjectLayer layer, TimelineObjectPath path, boolean selected, boolean focused, boolean highlighted, int row) {
        this.flight = (FlightTimelineObject)path.getTimelineObject();
        this.selected = selected;
        this.focused = focused;
        this.highlighted = highlighted;
        return this;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        ROW row = (ROW)this.flight.getUserObject();
        Graphics2D g2d = (Graphics2D)g2;
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        int y2 = (h2 - this.barHeight) / 2;
        g2d.setColor(this.aircraftBackgroundColorMap.get(row.getACTYPE()));
        if (this.highlighted) {
            g2d.setColor(this.highlightColor);
        } else if (this.focused) {
            g2d.setColor(this.focusColor);
        }
        g2d.fillRect(0, y2, w2, this.barHeight);
        Paint oldPaint = g2d.getPaint();
        Paint paint = this.texturePaintMap.get(row.getSERVICETYPE());
        if (paint != null) {
            g2d.setPaint(paint);
            g2d.fillRect(0, y2, w2, this.barHeight);
        }
        g2d.setPaint(oldPaint);
        g2d.setColor(this.aircraftBackgroundColorMap.get(row.getACTYPE()).darker());
        g2d.drawRect(0, y2, w2 - 1, this.barHeight - 1);
        FontMetrics fm = g2d.getFontMetrics();
        int ascent = fm.getAscent();
        String flightNo = row.getFLIGHTNO();
        int length = fm.stringWidth(flightNo);
        if (w2 - 8 > length && SettingsHUD.showFlightNumbers.isSelected()) {
            g2d.setColor(this.aircraftForegroundColorMap.get(row.getACTYPE()));
            String str = row.getFLIGHTNO();
            int strWidth = fm.stringWidth(str);
            int strX = w2 / 2 - fm.stringWidth(str) / 2;
            int strY = y2 + this.barHeight / 2 + ascent / 2 - 1;
            g2d.setColor(Color.DARK_GRAY);
            g2d.fillRect(strX - 2, 2, strWidth + 2, this.barHeight - 4);
            g2d.setColor(Color.WHITE);
            g2d.drawString(str, strX, strY);
        }
        if (this.focused) {
            g2d.setColor(Color.RED);
            g2d.drawRect(0, y2, w2 - 1, this.barHeight - 1);
        } else if (this.selected) {
            g2d.setColor(Color.BLUE);
            g2d.drawRect(0, y2, w2 - 1, this.barHeight - 1);
        }
        Object status = this.flight.getStatus();
        if (status != null) {
            Icon icon = null;
            if (status.equals("follow-up")) {
                icon = this.followUpIcon;
            } else if (status.equals("invalid")) {
                icon = this.invalidIcon;
            }
            if (icon != null) {
                icon.paintIcon(this, g2d, w2 / 2 - icon.getIconWidth() / 2, h2 / 2 - icon.getIconHeight() / 2);
            }
        }
        if (row.getSERVICETYPE().equals("Z")) {
            this.starIcon.paintIcon(this, g2d, 0, h2 / 2 - this.starIcon.getIconHeight() / 2);
            this.starIcon.paintIcon(this, g2d, w2 - this.starIcon.getIconWidth(), h2 / 2 - this.starIcon.getIconHeight() / 2);
        }
    }

    private Map<String, Paint> createTexturePaintMap() {
        HashMap<String, Paint> map = new HashMap<String, Paint>();
        map.put("E", new TexturePaint(this.eTextureImage, new Rectangle(0, 0, 4, 4)));
        map.put("N", new TexturePaint(this.nTextureImage, new Rectangle(0, 0, 4, 4)));
        map.put("Y", new TexturePaint(this.yTextureImage, new Rectangle(0, 0, 4, 4)));
        map.put("J", new TexturePaint(this.jTextureImage, new Rectangle(0, 0, 4, 4)));
        map.put("Z", new TexturePaint(this.zTextureImage, new Rectangle(0, 0, 4, 4)));
        return map;
    }

    @Override
    public Insets getTimelineObjectRendererInsets(int x2, int y2, int width, int height) {
        int bh = Math.min(this.barHeight, height);
        this.insets.left = 0;
        this.insets.right = 0;
        this.insets.top = (height - bh) / 2;
        this.insets.bottom = (height - bh) / 2;
        return this.insets;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(int x2, int y2, int width, int height) {
    }

    @Override
    public void repaint(long tm) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

