/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing;

import com.dlsc.emirates.model.FlightTimelineObject;
import com.dlsc.emirates.model.ModelFactory;
import com.dlsc.emirates.swing.AbstractContentPanel;
import com.dlsc.emirates.swing.View;
import com.dlsc.emirates.swing.Workbench;
import com.dlsc.emirates.swing.renderer.EmiratesCapacityObjectRenderer;
import com.dlsc.emirates.swing.renderer.EmiratesTreeTableCellRenderer;
import com.dlsc.emirates.swing.renderer.FlightTimelineObjectRenderer;
import com.dlsc.flexgantt.model.dateline.DatelineModelException;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.model.gantt.DefaultCapacityObject;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.swing.GanttChart;
import com.dlsc.flexgantt.swing.mac.MacComponentFactory;
import com.dlsc.flexgantt.swing.util.MultiGanttChartSynchController;
import de.centigrade.bizlaf.BizLafControl;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class SynchDemoContentPanel
extends AbstractContentPanel {
    private JDialog externalDialog;
    private GanttChart[] gantt;
    private ModelFactory modelFactory;

    public SynchDemoContentPanel(ModelFactory modelFactory, Workbench workbench, View view) {
        super(workbench, view);
        this.modelFactory = modelFactory;
        for (int i2 = 0; i2 < this.gantt.length; ++i2) {
            this.gantt[i2].setModel(modelFactory.getFleetModel());
            try {
                this.gantt[i2].getDatelineModel().setTimeSpan(modelFactory.getHorizon());
                this.gantt[i2].setGranularity(TimeGranularity.SIX_HOURS);
                this.gantt[i2].getTreeTable().setCellRenderer(DefaultGanttChartNode.class, new EmiratesTreeTableCellRenderer());
                this.gantt[i2].getLayerContainer().setTimelineObjectRenderer(FlightTimelineObject.class, new FlightTimelineObjectRenderer());
                this.gantt[i2].getLayerContainer().setTimelineObjectRenderer(DefaultCapacityObject.class, new EmiratesCapacityObjectRenderer());
                this.gantt[i2].getTreeTable().setRootVisible(false);
                this.gantt[i2].optimizeColumnWidth();
                this.gantt[i2].resetToPreferredSizes();
                continue;
            }
            catch (DatelineModelException e2) {
                e2.printStackTrace();
            }
        }
    }

    @Override
    protected JComponent createContent() {
        JPanel content = new JPanel();
        content.setLayout(new GridLayout(2, 2, 5, 5));
        BizLafControl.get().setStyle(content, ":bizlaf:Header");
        this.gantt = new GanttChart[5];
        for (int i2 = 0; i2 < this.gantt.length; ++i2) {
            this.gantt[i2] = new GanttChart(MacComponentFactory.getInstance());
            if (i2 >= 4) continue;
            content.add(this.gantt[i2]);
        }
        new MultiGanttChartSynchController(this.gantt);
        return content;
    }

    @Override
    protected JComponent createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        BizLafControl.get().setStyle(toolBar, ":bizlaf:RibbonLike");
        AbstractAction externalAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SynchDemoContentPanel.this.showExternal();
            }
        };
        externalAction.putValue("SwingLargeIconKey", new ImageIcon(AbstractContentPanel.class.getResource("windows.png")));
        externalAction.putValue("Name", "External");
        JButton externalButton = new JButton(externalAction);
        externalButton.setFocusPainted(false);
        externalButton.setBorderPainted(false);
        toolBar.add(externalButton);
        return toolBar;
    }

    protected void showExternal() {
        if (this.externalDialog == null) {
            this.externalDialog = new JDialog(SwingUtilities.getWindowAncestor(this), "External Gantt");
            this.externalDialog.add("Center", this.gantt[4]);
            this.externalDialog.setModalityType(Dialog.ModalityType.MODELESS);
            this.externalDialog.setSize(800, 600);
        }
        this.externalDialog.setVisible(true);
    }
}

