/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing;

import com.dlsc.emirates.swing.AbstractContentPanel;
import com.dlsc.emirates.swing.View;
import com.dlsc.emirates.swing.Workbench;
import com.dlsc.emirates.swing.renderer.list.ViewListCellRenderer;
import de.centigrade.bizlaf.BizLafControl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.miginfocom.swing.MigLayout;

public class Header
extends JPanel
implements ActionListener {
    private JLabel primaryHeaderLabel;
    private JLabel secondaryHeaderLabel;
    private JComboBox viewSelectionBox;
    private Workbench workbench;
    private View view;

    public Header(Workbench workbench, View view, final AbstractContentPanel contentPanel) {
        this.workbench = workbench;
        this.view = view;
        this.primaryHeaderLabel = new JLabel("");
        this.secondaryHeaderLabel = new JLabel("");
        this.setLayout(new MigLayout("", "[]20[grow]20[]", "[]"));
        this.add((Component)this.primaryHeaderLabel, "");
        this.add((Component)this.secondaryHeaderLabel, "");
        this.viewSelectionBox = new JComboBox();
        this.viewSelectionBox.setRenderer(new ViewListCellRenderer());
        if (!view.getType().equals((Object)View.Type.TITLE) && workbench.getViews().size() > 1) {
            this.add(this.viewSelectionBox);
        }
        BizLafControl.get().setStyle(this, ":bizlaf:Header");
        BizLafControl.get().setStyle(this.primaryHeaderLabel, ":bizlaf:HeaderPrimary");
        BizLafControl.get().setStyle(this.secondaryHeaderLabel, ":bizlaf:HeaderSeconary");
        this.secondaryHeaderLabel.setText(view.getSecondaryTitle());
        ArrayList<View> views = workbench.getViews();
        this.viewSelectionBox.setModel(new DefaultComboBoxModel<Object>(views.toArray()));
        this.viewSelectionBox.setSelectedItem(view);
        this.viewSelectionBox.addActionListener(this);
        this.primaryHeaderLabel.setText(view.getPrimaryTitle());
        if (!view.getType().equals((Object)View.Type.TITLE)) {
            final JTextField searchField = new JTextField(20);
            BizLafControl.get().setStyle(searchField, ":bizlaf:Search");
            this.add(searchField);
            searchField.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e2) {
                    contentPanel.setSearchText(searchField.getText());
                }
            });
        }
    }

    public JLabel getSecondaryHeaderLabel() {
        return this.secondaryHeaderLabel;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        View selection = (View)this.viewSelectionBox.getSelectedItem();
        this.workbench.showView(selection);
    }

    public void activate() {
        this.viewSelectionBox.setSelectedItem(this.view);
    }
}

