/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.swing;

import com.dlsc.emirates.swing.Header;
import com.dlsc.emirates.swing.View;
import com.dlsc.emirates.swing.Workbench;
import com.dlsc.emirates.swing.components.AnimatedSplitPane;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.swing.StatusBar;
import de.centigrade.bizlaf.BizLafControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import net.miginfocom.swing.MigLayout;

public abstract class AbstractContentPanel
extends JPanel
implements IProgressMonitor {
    private Workbench workbench;
    private Header header;
    private AnimatedSplitPane splitPane;
    private View view;
    private StatusBar statusBar;

    public AbstractContentPanel(Workbench workbench, View view) {
        this.workbench = workbench;
        this.view = view;
        this.setLayout(new MigLayout("insets 0 0 0 0, wrap 1, gap 0", "[grow]", "[][][grow][]"));
        JComponent content = this.createContent();
        JComponent drawer = this.createDrawer();
        this.statusBar = this.createStatusBar();
        JComponent toolBar = this.createToolBar();
        JComponent header = this.createHeader();
        this.splitPane = new AnimatedSplitPane();
        this.splitPane.setTopComponent(content);
        this.splitPane.setBottomComponent(drawer);
        this.statusBar.setMinimumSize(new Dimension(10, 32));
        this.statusBar.setPreferredSize(new Dimension(10, 32));
        this.add((Component)toolBar, "grow");
        this.add((Component)header, "grow");
        this.add((Component)this.splitPane, "grow");
        this.add((Component)this.statusBar, "grow");
        this.splitPane.closeWithoutAnimation();
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public View getView() {
        return this.view;
    }

    public Workbench getWorkbench() {
        return this.workbench;
    }

    public void activate() {
        this.header.activate();
    }

    public Header getHeader() {
        return this.header;
    }

    protected JComponent createHeader() {
        this.header = new Header(this.workbench, this.view, this);
        return this.header;
    }

    protected JComponent createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        BizLafControl.get().setStyle(toolBar, ":bizlaf:RibbonLike");
        AbstractAction exitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (JOptionPane.showConfirmDialog(AbstractContentPanel.this, "Really quit?", "Exit", 0) == 0) {
                    System.exit(0);
                }
            }
        };
        exitAction.putValue("SwingLargeIconKey", new ImageIcon(AbstractContentPanel.class.getResource("exit.png")));
        exitAction.putValue("Name", "Exit");
        JButton exitButton = new JButton(exitAction);
        exitButton.setFocusPainted(false);
        exitButton.setBorderPainted(false);
        toolBar.add(exitButton);
        return toolBar;
    }

    protected JComponent createContent() {
        JLabel label = new JLabel("Content Missing!!!!");
        label.setOpaque(true);
        label.setBackground(Color.WHITE);
        label.setHorizontalAlignment(0);
        return label;
    }

    protected StatusBar createStatusBar() {
        StatusBar statusBar = new StatusBar();
        BizLafControl.get().setStyle(statusBar, ":bizlaf:FooterBar");
        statusBar.getResizeIconLabel().setVisible(false);
        return statusBar;
    }

    protected JComponent createDrawer() {
        return new JLabel("Not implemented, yet!");
    }

    protected JLabel createFooterLabel(String text) {
        JLabel footerLabel = new JLabel(text);
        this.makeFooterLabel(footerLabel);
        return footerLabel;
    }

    protected void makeFooterLabel(JLabel label) {
        BizLafControl.get().setStyle(label, ":bizlaf:Shadowed");
        label.setForeground(Color.WHITE);
    }

    public AnimatedSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void setSearchText(String text) {
    }

    @Override
    public void beginTask(String arg0, int arg1) {
    }

    @Override
    public void done() {
    }

    @Override
    public void internalWorked(double arg0) {
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public void setCanceled(boolean arg0) {
    }

    @Override
    public void setTaskName(String arg0) {
    }

    @Override
    public void subTask(String arg0) {
    }

    @Override
    public void worked(int arg0) {
    }

    public void export(boolean all) throws Exception {
    }
}

