/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates.model;

import com.dlsc.emirates.generated.flights.ROW;
import com.dlsc.emirates.model.FlightTimelineObject;
import com.dlsc.emirates.model.ModelFactory;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.TimeSpan;
import com.dlsc.flexgantt.model.dateline.TimeGranularity;
import com.dlsc.flexgantt.model.gantt.BinarySearchTimelineObjectIterator;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ILayer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class AircraftGanttChartNode
extends DefaultGanttChartNode<ROW, FlightTimelineObject> {
    public static final int ROW_HEIGHT = 36;
    private int lineCount;

    public AircraftGanttChartNode(ROW plane) {
        super(plane);
        if (plane != null) {
            this.setKey(plane.getResource());
        }
        this.setRowHeight(36);
    }

    @Override
    public Object getColumnValue(int modelIndex) {
        switch (modelIndex) {
            case 1: {
                return ((ROW)this.getTypedUserObject()).getACTYPE();
            }
            case 2: {
                return this.getTimelineObjects().size();
            }
            case 3: {
                return this.getLineCount();
            }
        }
        return "";
    }

    @Override
    public Iterator<FlightTimelineObject> getTimelineObjectsIterator(ILayer layer, ITimeSpan span) {
        if (layer == null) {
            throw new IllegalArgumentException("layer can not be NULL");
        }
        if (span == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        List<Object> list = this.getTimelineObjects(layer);
        if (list != null && list.size() > 0) {
            return new BinarySearchTimelineObjectIterator<Object>(list, span);
        }
        list = Collections.emptyList();
        return list.iterator();
    }

    public void calculateLines() {
        int i2;
        List timelineObjects = this.getTimelineObjects();
        this.lineCount = 0;
        if (timelineObjects.size() > 1) {
            for (i2 = 0; i2 < timelineObjects.size(); ++i2) {
                FlightTimelineObject checkedFlight = (FlightTimelineObject)timelineObjects.get(i2);
                checkedFlight.setLineIndex(0);
                if (i2 <= 0) continue;
                int j2 = i2 - 1;
                do {
                    FlightTimelineObject flight;
                    if (!(flight = (FlightTimelineObject)timelineObjects.get(j2)).getTimeSpan().intersects(checkedFlight.getTimeSpan())) continue;
                    checkedFlight.setLineIndex(Math.max(checkedFlight.getLineIndex(), flight.getLineIndex() + 1));
                } while (--j2 > -1);
            }
        }
        for (i2 = 0; i2 < timelineObjects.size(); ++i2) {
            this.lineCount = Math.max(this.lineCount, ((FlightTimelineObject)timelineObjects.get(i2)).getLineIndex() + 1);
        }
        if (this.lineCount > 1) {
            this.setLineCount(this.lineCount);
            this.setRowHeight(this.lineCount * 36);
        }
    }

    public void showOverlappingFlights(boolean selected) {
        if (selected) {
            this.setLineCount(this.lineCount);
            this.setRowHeight(this.lineCount * 36);
        } else {
            this.setLineCount(0);
            this.setRowHeight(36);
        }
    }

    public void updateSpreadsheetData(ITimeSpan horizon) {
        this.clearSpreadsheetValues(ModelFactory.SPREADSHEET);
        TimeZone timeZone = TimeZone.getDefault();
        long dayStartTime = TimeGranularity.DAY_SHORT.adjustTime(horizon.getStartTime(), timeZone);
        long dayEndTime = TimeGranularity.DAY_SHORT.increment(dayStartTime, timeZone);
        do {
            dayStartTime = dayEndTime + 1L;
            dayEndTime = TimeGranularity.DAY_SHORT.increment(dayEndTime, timeZone);
            TimeSpan span = new TimeSpan(dayStartTime, dayEndTime);
            this.setSpreadsheetValue(ModelFactory.SPREADSHEET, "x", span);
        } while (dayEndTime < horizon.getEndTime());
    }
}

