/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.emirates;

import com.dlsc.emirates.OSXAdapter;
import com.dlsc.emirates.swing.AircraftGanttChart;
import com.dlsc.emirates.swing.MenuBar;
import com.dlsc.emirates.swing.Workbench;
import com.dlsc.emirates.swing.components.AnimatedSplitPane;
import com.dlsc.emirates.swing.session.AnimatedSplitPaneSessionStorageProperty;
import com.dlsc.emirates.swing.session.EmiratesGanttChartPropertySupport;
import com.dlsc.emirates.swing.session.XProperties;
import com.dlsc.flexgantt.icons.IconRegistry;
import com.dlsc.flexgantt.icons.png16xp.Png16XPIconMap;
import com.dlsc.flexgantt.swing.selector.Selector;
import com.dlsc.flexgantt.swing.util.ColorUtil;
import com.dlsc.flexgantt.util.FlexGanttLicenseManager;
import de.centigrade.bizlaf.BizLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.jdesktop.application.Application;
import org.jdesktop.application.SessionStorage;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.swingx.JXTable;

public class EmiratesPOC
extends SingleFrameApplication {
    @Override
    protected void initialize(String[] args) {
        super.initialize(args);
    }

    @Override
    protected void startup() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                EmiratesPOC.this.shutdown();
            }
        });
        SessionStorage sessionStorage = this.getContext().getSessionStorage();
        sessionStorage.putProperty(AnimatedSplitPane.class, new AnimatedSplitPaneSessionStorageProperty());
        sessionStorage.putProperty(AircraftGanttChart.class, new EmiratesGanttChartPropertySupport());
        new XProperties().registerPersistenceDelegates();
        sessionStorage.putProperty(JXTable.class, new XProperties.XTableProperty());
        EmiratesPOC.applyLookAndFeel();
        JFrame frame = new JFrame("Emirates POC");
        if (System.getProperty("os.name").startsWith("Mac")) {
            OSXAdapter.setWindowCanFullScreen(frame, true);
        }
        frame.setDefaultCloseOperation(3);
        this.setMainFrame(frame);
        Workbench workbench = new Workbench(this);
        MenuBar bar = new MenuBar(workbench);
        this.getMainFrame().setJMenuBar(bar);
        workbench.setMenuBar(bar);
        workbench.setPreferredSize(new Dimension(900, 700));
        System.out.println(UIManager.getLookAndFeelDefaults().getString("Cezanne.productRuntimeSignature"));
        this.show(workbench);
    }

    @Override
    protected void shutdown() {
        super.shutdown();
    }

    public static void applyLookAndFeel() {
        ColorUtil.setGridColor(Color.LIGHT_GRAY);
        try {
            UIManager.setLookAndFeel(new BizLookAndFeel());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static boolean isMacOSX() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    public static boolean isAqua() {
        return UIManager.getLookAndFeel().getName().equals("Mac OS X");
    }

    public static void main(String[] args) {
        FlexGanttLicenseManager.setLicenseKey("LIC=DLSC;VEN=DLSC;VER=2;RUN=no;CTR=1;SignCode=1F;Signature=302D0215008F7E9DCB1A657E51E2FF09400388595003149C7B021448AC6616D5F09B8D822E14ECFD2BF52DE9A31B13");
        Selector.setGlobalAnimationEnabled(false);
        SecurityManager sm = System.getSecurityManager();
        try {
            String language;
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
            if ((language = System.getProperty("language")) != null) {
                Locale.setDefault(new Locale(language));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        IconRegistry.setIconMap(new Png16XPIconMap());
        Application.launch(EmiratesPOC.class, args);
    }
}

