/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.prompt.BuddySupport;

public class BuddyLayoutAndBorder
implements LayoutManager,
Border,
PropertyChangeListener,
UIResource {
    private JTextField textField;
    private Border borderDelegate;

    protected void install(JTextField textField) {
        this.uninstall();
        this.textField = textField;
        textField.setLayout(this);
        this.replaceBorderIfNecessary();
        textField.addPropertyChangeListener("border", this);
    }

    public Border getBorderDelegate() {
        return this.borderDelegate;
    }

    protected void replaceBorderIfNecessary() {
        Border original = this.textField.getBorder();
        if (!(original instanceof BuddyLayoutAndBorder)) {
            this.borderDelegate = original;
            this.textField.setBorder(this);
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension d2 = new Dimension();
        for (Component c2 : BuddySupport.getLeft(this.textField)) {
            d2.height = Math.max(d2.height, c2.getPreferredSize().height);
        }
        for (Component c2 : BuddySupport.getRight(this.textField)) {
            d2.height = Math.max(d2.height, c2.getPreferredSize().height);
        }
        Insets insets = this.getRealBorderInsets();
        d2.height += insets.top + insets.bottom;
        d2.width += insets.left + insets.right;
        Insets outerMargin = BuddySupport.getOuterMargin(this.textField);
        if (outerMargin != null) {
            d2.width += outerMargin.left + outerMargin.right;
            d2.height += outerMargin.bottom + outerMargin.top;
        }
        return d2;
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void layoutContainer(Container parent) {
        Dimension size;
        Rectangle visibleRect = this.getVisibleRect();
        for (Component comp : BuddySupport.getLeft(this.textField)) {
            if (!comp.isVisible()) continue;
            size = comp.getPreferredSize();
            comp.setBounds(visibleRect.x, this.centerY(visibleRect, size), size.width, size.height);
            visibleRect.x += size.width;
            visibleRect.width -= size.width;
        }
        for (Component comp : BuddySupport.getRight(this.textField)) {
            if (!comp.isVisible()) continue;
            size = comp.getPreferredSize();
            comp.setBounds(visibleRect.x + visibleRect.width - size.width, this.centerY(visibleRect, size), size.width, size.height);
            visibleRect.width -= size.width;
        }
    }

    protected int centerY(Rectangle rect, Dimension size) {
        return (int)(rect.getCenterY() - (double)(size.height / 2));
    }

    protected Rectangle getVisibleRect() {
        Rectangle alloc = SwingUtilities.getLocalBounds(this.textField);
        this.substractInsets(alloc, this.getRealBorderInsets());
        this.substractInsets(alloc, BuddySupport.getOuterMargin(this.textField));
        return alloc;
    }

    private void substractInsets(Rectangle alloc, Insets insets) {
        if (insets != null) {
            alloc.x += insets.left;
            alloc.y += insets.top;
            alloc.width -= insets.left + insets.right;
            alloc.height -= insets.top + insets.bottom;
        }
    }

    public Insets getBorderInsets(Component c2) {
        Insets insets = null;
        insets = this.borderDelegate != null ? (Insets)this.borderDelegate.getBorderInsets(this.textField).clone() : new Insets(0, 0, 0, 0);
        if (this.textField == null) {
            return insets;
        }
        for (Component comp : BuddySupport.getLeft(this.textField)) {
            insets.left = insets.left + (comp.isVisible() ? comp.getPreferredSize().width : 0);
        }
        for (Component comp : BuddySupport.getRight(this.textField)) {
            insets.right = insets.right + (comp.isVisible() ? comp.getPreferredSize().width : 0);
        }
        Insets outerMargin = BuddySupport.getOuterMargin(this.textField);
        if (outerMargin != null) {
            insets.left += outerMargin.left;
            insets.right += outerMargin.right;
            insets.top += outerMargin.top;
            insets.bottom += outerMargin.bottom;
        }
        return insets;
    }

    public Insets getRealBorderInsets() {
        if (this.borderDelegate == null) {
            return new Insets(0, 0, 0, 0);
        }
        Insets insets = this.borderDelegate.getBorderInsets(this.textField);
        Insets margin = this.textField.getMargin();
        if (margin != null) {
            insets.left -= margin.left;
            insets.right -= margin.right;
            insets.top -= margin.top;
            insets.bottom -= margin.bottom;
        }
        return insets;
    }

    public boolean isBorderOpaque() {
        if (this.borderDelegate == null) {
            return false;
        }
        return this.borderDelegate.isBorderOpaque();
    }

    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (this.borderDelegate != null) {
            this.borderDelegate.paintBorder(c2, g2, x2, y2, width, height);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.replaceBorderIfNecessary();
    }

    public void uninstall() {
        if (this.textField != null) {
            this.textField.removePropertyChangeListener("border", this);
            if (this.textField.getBorder() == this) {
                this.textField.setBorder(this.borderDelegate);
            }
            this.textField.setLayout(null);
            this.textField = null;
        }
    }

    public String toString() {
        return String.format("%s (%s): %s", this.getClass().getName(), this.getBorderInsets(null), this.borderDelegate);
    }
}

